/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.registry;

import com.kekie6.colorfulazaleas.blocks.ColorfulAzaleaBushBlock;
import com.kekie6.colorfulazaleas.blocks.DroopingLeavesBlock;
import com.kekie6.colorfulazaleas.platform.Services;
import com.kekie6.colorfulazaleas.registry.RegistrationProvider;
import com.kekie6.colorfulazaleas.registry.RegistryObject;
import com.kekie6.colorfulazaleas.util.ColorfulAzaleaTreeGrower;
import com.kekie6.colorfulazaleas.util.ColorfulTreeDecorator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2571;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3614;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5207;
import net.minecraft.class_5212;
import net.minecraft.class_5458;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_7389;

public class AzaleaBlocks {
    public static final RegistrationProvider<class_2248> BLOCKS = RegistrationProvider.get(class_2378.field_11146, "colorfulazaleas");
    public static final RegistrationProvider<class_1792> ITEMS = RegistrationProvider.get(class_2378.field_11142, "colorfulazaleas");
    public static final RegistrationProvider<class_2975<?, ?>> CONFIGURED_FEATURES = RegistrationProvider.get(class_5458.field_25929, "colorfulazaleas");
    public static ColorfulTree[] trees;
    public static final RegistryObject<class_2248> DROOPING_AZALEA_LEAVES;

    public static void init() {
        trees = new ColorfulTree[AzaleaColors.values().length];
        for (int i = 0; i < AzaleaColors.values().length; ++i) {
            AzaleaBlocks.trees[i] = new ColorfulTree(AzaleaColors.values()[i]);
        }
    }

    public static RegistryObject<class_2248> registerBlock(String name, Supplier<class_2248> block) {
        RegistryObject<class_2248> registryObject = BLOCKS.register(name, block);
        ITEMS.register(name, () -> new class_1747((class_2248)registryObject.get(), new class_1792.class_1793().method_7892(Services.PLATFORM.getCreativeTab())));
        return registryObject;
    }

    static {
        DROOPING_AZALEA_LEAVES = AzaleaBlocks.registerBlock("drooping_azalea_leaves", () -> new DroopingLeavesBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15923).method_9634().method_9626(class_2498.field_28692)));
    }

    public static enum AzaleaColors {
        orange("tecal"),
        yellow("fiss"),
        red("roze"),
        blue("azule"),
        pink("bright"),
        purple("walnut"),
        white("titanium");

        final String title;

        private AzaleaColors(String title) {
            this.title = title;
        }
    }

    public static class ColorfulTree {
        public final String name;
        public final WoodType woodType;
        public final RegistryObject<class_2248> sapling;
        public final RegistryObject<class_2248> azaleaLeaves;
        public final RegistryObject<class_2248> floweringLeaves;
        public final RegistryObject<class_2248> bloomingLeaves;
        public final RegistryObject<class_2248> droopingLeaves;
        public final RegistryObject<class_2975<class_4643, ?>> feature;

        public ColorfulTree(AzaleaColors color) {
            this.name = color.name();
            this.woodType = new WoodType(color);
            this.azaleaLeaves = AzaleaBlocks.registerBlock(this.name + "_azalea_leaves", () -> new class_2397(class_4970.class_2251.method_9630((class_4970)class_2246.field_28673)));
            this.floweringLeaves = AzaleaBlocks.registerBlock(this.name + "_flowering_azalea_leaves", () -> new class_2397(class_4970.class_2251.method_9630((class_4970)class_2246.field_28673)));
            this.bloomingLeaves = AzaleaBlocks.registerBlock(this.name + "_blooming_azalea_leaves", () -> new class_2397(class_4970.class_2251.method_9630((class_4970)class_2246.field_28673).method_29292()));
            this.droopingLeaves = AzaleaBlocks.registerBlock(this.name + "_drooping_azalea_leaves", () -> new DroopingLeavesBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15923).method_9634().method_9626(class_2498.field_28692)));
            this.feature = ColorfulTree.registerAzaleaFeature(this.name + "_azalea_tree", () -> new class_2975(class_3031.field_24134, (class_3037)new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)this.woodType.log.get()), (class_5141)new class_5212(8, 4, 6), (class_4651)new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_28673.method_9564(), 3).method_34975((Object)this.floweringLeaves.get().method_9564(), 1).method_34974()), (class_4647)new class_5207((class_6017)class_6016.method_34998((int)3), (class_6017)class_6016.method_34998((int)3), 3), (class_5201)new class_5204(1, 0, 1)).method_34346((class_4651)class_4651.method_38432((class_2248)class_2246.field_28685)).method_27376(List.of(new class_7389(1.0f, 0, 1, (class_4651)class_4651.method_38433((class_2680)this.bloomingLeaves.get().method_9564()), 0, List.of(class_2350.field_11033)), new ColorfulTreeDecorator(this.droopingLeaves.get(), this.woodType.log.get()))).method_34347().method_23445()));
            this.sapling = AzaleaBlocks.registerBlock(this.name + "_azalea_sapling", () -> new ColorfulAzaleaBushBlock(new ColorfulAzaleaTreeGrower(this.feature), class_4970.class_2251.method_9630((class_4970)class_2246.field_28678).method_22488()));
            Services.PLATFORM.addBlockToAzaleaLootTable(this.sapling);
        }

        private static RegistryObject<class_2975<class_4643, ?>> registerAzaleaFeature(String name, Supplier<class_2975<class_4643, ?>> configuredFeature) {
            return CONFIGURED_FEATURES.register(name, configuredFeature);
        }
    }

    public static class WoodType {
        public final String name;
        public final RegistryObject<class_2248> log;
        public final RegistryObject<class_2248> wood;
        public final RegistryObject<class_2248> stripped_log;
        public final RegistryObject<class_2248> stripped_wood;
        public final RegistryObject<class_2248> planks;
        public final RegistryObject<class_2248> stair;
        public final RegistryObject<class_2248> slab;
        public final RegistryObject<class_2248> door;
        public final RegistryObject<class_2248> trapdoor;
        public final RegistryObject<class_2248> fence;
        public final RegistryObject<class_2248> fence_gate;
        public final RegistryObject<class_2248> pressure_plate;
        public final RegistryObject<class_2248> button;

        public WoodType(AzaleaColors color) {
            this.name = color.title;
            this.log = AzaleaBlocks.registerBlock(this.name + "_azalea_log", () -> new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10431)));
            this.wood = AzaleaBlocks.registerBlock(this.name + "_azalea_wood", () -> new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10126)));
            this.stripped_log = AzaleaBlocks.registerBlock("stripped_" + this.name + "_azalea_log", () -> new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10519)));
            this.stripped_wood = AzaleaBlocks.registerBlock("stripped_" + this.name + "_azalea_wood", () -> new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10250)));
            this.planks = AzaleaBlocks.registerBlock(this.name + "_azalea_planks", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161)));
            this.stair = AzaleaBlocks.registerBlock(this.name + "_azalea_stairs", () -> new class_2510(this.planks.get().method_9564(), class_4970.class_2251.method_9630((class_4970)((class_4970)this.planks.get()))));
            this.slab = AzaleaBlocks.registerBlock(this.name + "_azalea_slab", () -> new class_2482(class_4970.class_2251.method_9630((class_4970)class_2246.field_10119)));
            this.door = AzaleaBlocks.registerBlock(this.name + "_azalea_door", () -> new class_2323(class_4970.class_2251.method_9630((class_4970)class_2246.field_10149)));
            this.trapdoor = AzaleaBlocks.registerBlock(this.name + "_azalea_trapdoor", () -> new class_2533(class_4970.class_2251.method_9630((class_4970)class_2246.field_10137)));
            this.fence = AzaleaBlocks.registerBlock(this.name + "_azalea_fence", () -> new class_2354(class_4970.class_2251.method_9630((class_4970)class_2246.field_10620)));
            this.fence_gate = AzaleaBlocks.registerBlock(this.name + "_azalea_fence_gate", () -> new class_2349(class_4970.class_2251.method_9630((class_4970)class_2246.field_10188)));
            this.pressure_plate = AzaleaBlocks.registerBlock(this.name + "_azalea_pressure_plate", () -> new class_2440(class_2440.class_2441.field_11361, class_4970.class_2251.method_9630((class_4970)class_2246.field_10484)));
            this.button = AzaleaBlocks.registerBlock(this.name + "_azalea_button", () -> new class_2571(class_4970.class_2251.method_9630((class_4970)class_2246.field_10057)));
        }
    }
}

