/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot;

import com.google.common.collect.ImmutableSet;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.CornBlock;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import com.sihenzhang.crockpot.block.CrockPotUnknownCropsBlock;
import com.sihenzhang.crockpot.container.CrockPotContainer;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotSeedsItem;
import com.sihenzhang.crockpot.item.CrockPotUnknownSeedsItem;
import com.sihenzhang.crockpot.item.food.Candy;
import com.sihenzhang.crockpot.item.food.CrockPotFood;
import com.sihenzhang.crockpot.item.food.FlowerSalad;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCream;
import com.sihenzhang.crockpot.loot.CrockPotUnknownSeedsDropModifier;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import com.sihenzhang.crockpot.world.CrockPotCropsFeature;
import com.sihenzhang.crockpot.world.CrockPotCropsFeatureConfig;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.EnumUtils;

public final class CrockPotRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crockpot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"crockpot");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"crockpot");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"crockpot");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"crockpot");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"crockpot");
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"crockpot");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"crockpot");
    public static final Effect witherResistanceEffect = CrockPotRegistry.register(EFFECTS, "wither_resistance", new Effect(EffectType.BENEFICIAL, 7471247){});
    public static final Block crockPotBasicBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_basic", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 0;
        }
    });
    public static final Item crockPotBasicBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_basic", new CrockPotBlockItem(crockPotBasicBlock));
    public static final Block crockPotAdvancedBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_advanced", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 1;
        }
    });
    public static final Item crockPotAdvancedBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_advanced", new CrockPotBlockItem(crockPotAdvancedBlock));
    public static final Block crockPotUltimateBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_ultimate", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 2;
        }
    });
    public static final Item crockPotUltimateBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_ultimate", new CrockPotBlockItem(crockPotUltimateBlock));
    public static final TileEntityType<CrockPotTileEntity> crockPotTileEntity = CrockPotRegistry.register(TILE_ENTITIES, "crock_pot", TileEntityType.Builder.func_223042_a(CrockPotTileEntity::new, (Block[])new Block[]{crockPotBasicBlock, crockPotAdvancedBlock, crockPotUltimateBlock}).func_206865_a(null));
    public static final ContainerType<CrockPotContainer> crockPotContainer = CrockPotRegistry.register(CONTAINERS, "crock_pot", IForgeContainerType.create((windowId, inv, data) -> {
        BlockPos pos = data.func_179259_c();
        TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
        return new CrockPotContainer(windowId, inv, (CrockPotTileEntity)Objects.requireNonNull(tileEntity));
    }));
    public static final GlobalLootModifierSerializer<CrockPotUnknownSeedsDropModifier> unknownSeedsDropModifier = CrockPotRegistry.register(LOOT_MODIFIER_SERIALIZERS, "unknown_seeds_drop", new CrockPotUnknownSeedsDropModifier.Serializer());
    public static final Block unknownCropsBlock = (Block)CrockPotRegistry.register(BLOCKS, "unknown_crops", new CrockPotUnknownCropsBlock());
    public static final Item unknownSeeds = (Item)CrockPotRegistry.register(ITEMS, "unknown_seeds", new CrockPotUnknownSeedsItem());
    public static final Feature<CrockPotCropsFeatureConfig> cropsPatchFeature = CrockPotRegistry.register(FEATURES, "crops_patch", new CrockPotCropsFeature(CrockPotCropsFeatureConfig.CODEC));
    public static final Block asparagusBlock = (Block)CrockPotRegistry.register(BLOCKS, "asparaguses", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return asparagusSeeds;
        }
    });
    public static final Item asparagusSeeds = (Item)CrockPotRegistry.register(ITEMS, "asparagus_seeds", new CrockPotSeedsItem(asparagusBlock));
    public static final Item asparagus = CrockPotRegistry.register(ITEMS, "asparagus", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Block cornBlock = (Block)CrockPotRegistry.register(BLOCKS, "corns", new CornBlock());
    public static final Item cornSeeds = (Item)CrockPotRegistry.register(ITEMS, "corn_seeds", new CrockPotSeedsItem(cornBlock));
    public static final Item corn = CrockPotRegistry.register(ITEMS, "corn", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Item popcorn = CrockPotRegistry.register(ITEMS, "popcorn", CrockPotFood.builder().hunger(3).saturation(0.8f).duration(FoodUseDuration.FAST).build());
    public static final Block eggplantBlock = (Block)CrockPotRegistry.register(BLOCKS, "eggplants", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return eggplantSeeds;
        }
    });
    public static final Item eggplantSeeds = (Item)CrockPotRegistry.register(ITEMS, "eggplant_seeds", new CrockPotSeedsItem(eggplantBlock));
    public static final Item eggplant = CrockPotRegistry.register(ITEMS, "eggplant", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Item cookedEggplant = CrockPotRegistry.register(ITEMS, "cooked_eggplant", CrockPotFood.builder().hunger(5).saturation(0.6f).build());
    public static final Block onionBlock = (Block)CrockPotRegistry.register(BLOCKS, "onions", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return onionSeeds;
        }
    });
    public static final Item onionSeeds = (Item)CrockPotRegistry.register(ITEMS, "onion_seeds", new CrockPotSeedsItem(onionBlock));
    public static final Item onion = CrockPotRegistry.register(ITEMS, "onion", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Block pepperBlock = (Block)CrockPotRegistry.register(BLOCKS, "peppers", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return pepperSeeds;
        }
    });
    public static final Item pepperSeeds = (Item)CrockPotRegistry.register(ITEMS, "pepper_seeds", new CrockPotSeedsItem(pepperBlock));
    public static final Item pepper = CrockPotRegistry.register(ITEMS, "pepper", CrockPotFood.builder().hunger(3).saturation(0.6f).damage(CrockPotDamageSource.SPICY, 1.0f).build());
    public static final Block tomatoBlock = (Block)CrockPotRegistry.register(BLOCKS, "tomatoes", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return tomatoSeeds;
        }
    });
    public static final Item tomatoSeeds = (Item)CrockPotRegistry.register(ITEMS, "tomato_seeds", new CrockPotSeedsItem(tomatoBlock));
    public static final Item tomato = CrockPotRegistry.register(ITEMS, "tomato", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Set<Item> seeds = ImmutableSet.of((Object)unknownSeeds, (Object)asparagusSeeds, (Object)cornSeeds, (Object)eggplantSeeds, (Object)onionSeeds, (Object)pepperSeeds, (Object[])new Item[]{tomatoSeeds});
    public static final Set<Item> crops = ImmutableSet.of((Object)asparagus, (Object)corn, (Object)eggplant, (Object)onion, (Object)pepper, (Object)tomato, (Object[])new Item[0]);
    public static final Set<Item> cookedCrops = ImmutableSet.of((Object)popcorn, (Object)cookedEggplant);
    public static final Item cookedEgg = CrockPotRegistry.register(ITEMS, "cooked_egg", CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static final Item frogLegs = CrockPotRegistry.register(ITEMS, "frog_legs", CrockPotFood.builder().hunger(2).saturation(0.4f).build());
    public static final Item cookedFrogLegs = CrockPotRegistry.register(ITEMS, "cooked_frog_legs", CrockPotFood.builder().hunger(5).saturation(0.7f).build());
    public static final Item milkBottle = CrockPotRegistry.register(ITEMS, "milk_bottle", CrockPotFood.builder().hunger(0).saturation(0.0f).setAlwaysEdible().setDrink().tooltip("milk_bottle").build());
    public static final Item syrup = CrockPotRegistry.register(ITEMS, "syrup", CrockPotFood.builder().hunger(1).saturation(0.3f).setDrink().build());
    public static final Item asparagusSoup = CrockPotRegistry.register(ITEMS, "asparagus_soup", CrockPotFood.builder().hunger(4).saturation(0.3f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().removePotion(Effects.field_76437_t).removePotion(Effects.field_76419_f).removePotion(Effects.field_76440_q).removePotion(Effects.field_220309_E).build());
    public static final Item avaj = CrockPotRegistry.register(ITEMS, "avaj", CrockPotFood.builder().hunger(2).saturation(3.6f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 38800, 2).setHidden().rarity(Rarity.EPIC).build());
    public static final Item baconEggs = CrockPotRegistry.register(ITEMS, "bacon_eggs", CrockPotFood.builder().hunger(12).saturation(0.8f).heal(4.0f).build());
    public static final Item boneSoup = CrockPotRegistry.register(ITEMS, "bone_soup", CrockPotFood.builder().hunger(10).saturation(0.6f).effect(Effects.field_76444_x, 2400, 1).build());
    public static final Item boneStew = CrockPotRegistry.register(ITEMS, "bone_stew", CrockPotFood.builder().hunger(20).saturation(0.4f).duration(FoodUseDuration.SUPER_SLOW).effect(Effects.field_76432_h, 1, 1).build());
    public static final Item californiaRoll = CrockPotRegistry.register(ITEMS, "california_roll", CrockPotFood.builder().hunger(10).saturation(0.6f).heal(4.0f).effect(Effects.field_76444_x, 1200).build());
    public static final Item candy = CrockPotRegistry.register(ITEMS, "candy", new Candy());
    public static final Item ceviche = CrockPotRegistry.register(ITEMS, "ceviche", CrockPotFood.builder().hunger(7).saturation(0.7f).setAlwaysEdible().effect(Effects.field_76429_m, 400, 1).effect(Effects.field_76444_x, 400, 1).build());
    public static final Item fishSticks = CrockPotRegistry.register(ITEMS, "fish_sticks", CrockPotFood.builder().hunger(7).saturation(0.7f).effect(Effects.field_76428_l, 600).build());
    public static final Item fishTacos = CrockPotRegistry.register(ITEMS, "fish_tacos", CrockPotFood.builder().hunger(8).saturation(0.9f).heal(2.0f).build());
    public static final Item flowerSalad = CrockPotRegistry.register(ITEMS, "flower_salad", new FlowerSalad());
    public static final Item froggleBunwich = CrockPotRegistry.register(ITEMS, "froggle_bunwich", CrockPotFood.builder().hunger(7).saturation(0.8f).build());
    public static final Item fruitMedley = CrockPotRegistry.register(ITEMS, "fruit_medley", CrockPotFood.builder().hunger(8).saturation(0.4f).effect(Effects.field_76424_c, 3600).build());
    public static final Item gazpacho = CrockPotRegistry.register(ITEMS, "gazpacho", CrockPotFood.builder().hunger(6).saturation(0.4f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76426_n, 12000).build());
    public static final Item honeyHam = CrockPotRegistry.register(ITEMS, "honey_ham", CrockPotFood.builder().hunger(12).saturation(0.8f).effect(Effects.field_76428_l, 400).effect(Effects.field_76444_x, 1200, 1).heal(6.0f).build());
    public static final Item honeyNuggets = CrockPotRegistry.register(ITEMS, "honey_nuggets", CrockPotFood.builder().hunger(8).saturation(0.3f).effect(Effects.field_76428_l, 200).effect(Effects.field_76444_x, 1200).heal(4.0f).build());
    public static final Item hotChili = CrockPotRegistry.register(ITEMS, "hot_chili", CrockPotFood.builder().hunger(9).saturation(0.8f).effect(Effects.field_76420_g, 1800).effect(Effects.field_76422_e, 1800).build());
    public static final Item hotCocoa = CrockPotRegistry.register(ITEMS, "hot_cocoa", CrockPotFood.builder().hunger(2).saturation(0.1f).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 9600, 1).removePotion(Effects.field_76421_d).removePotion(Effects.field_76419_f).build());
    public static final Item iceCream = CrockPotRegistry.register(ITEMS, "ice_cream", new IceCream());
    public static final Item icedTea = CrockPotRegistry.register(ITEMS, "iced_tea", CrockPotFood.builder().hunger(3).saturation(0.1f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76430_j, 6000, 1).build());
    public static final Item jammyPreserves = CrockPotRegistry.register(ITEMS, "jammy_preserves", CrockPotFood.builder().hunger(6).saturation(0.3f).duration(FoodUseDuration.FAST).build());
    public static final Item kabobs = CrockPotRegistry.register(ITEMS, "kabobs", CrockPotFood.builder().hunger(7).saturation(0.7f).build());
    public static final Item meatBalls = CrockPotRegistry.register(ITEMS, "meat_balls", CrockPotFood.builder().hunger(9).saturation(0.5f).build());
    public static final Item monsterLasagna = CrockPotRegistry.register(ITEMS, "monster_lasagna", CrockPotFood.builder().hunger(7).saturation(0.2f).effect(Effects.field_76438_s, 300).effect(Effects.field_76436_u, 40).damage(CrockPotDamageSource.MONSTER_FOOD, 6.0f).build());
    public static final Item monsterTartare = CrockPotRegistry.register(ITEMS, "monster_tartare", CrockPotFood.builder().hunger(8).saturation(0.7f).effect(Effects.field_76420_g, 2400, 1).build());
    public static final Item moqueca = CrockPotRegistry.register(ITEMS, "moqueca", CrockPotFood.builder().hunger(14).saturation(0.7f).duration(FoodUseDuration.SLOW).effect(Effects.field_180152_w, 1800, 2).heal(6.0f).build());
    public static final Item mushyCake = CrockPotRegistry.register(ITEMS, "mushy_cake", CrockPotFood.builder().hunger(6).saturation(0.4f).duration(FoodUseDuration.FAST).setAlwaysEdible().effect(witherResistanceEffect, 1200).build());
    public static final Item pepperPopper = CrockPotRegistry.register(ITEMS, "pepper_popper", CrockPotFood.builder().hunger(8).saturation(0.8f).effect(Effects.field_76420_g, 1200, 1).build());
    public static final Item perogies = CrockPotRegistry.register(ITEMS, "perogies", CrockPotFood.builder().hunger(8).saturation(0.8f).heal(6.0f).build());
    public static final Item potatoSouffle = CrockPotRegistry.register(ITEMS, "potato_souffle", CrockPotFood.builder().hunger(8).saturation(0.7f).effect(Effects.field_76429_m, 1800, 1).build());
    public static final Item potatoTornado = CrockPotRegistry.register(ITEMS, "potato_tornado", CrockPotFood.builder().hunger(8).saturation(0.6f).duration(FoodUseDuration.FAST).removePotion(Effects.field_76438_s).build());
    public static final Item powCake = CrockPotRegistry.register(ITEMS, "pow_cake", CrockPotFood.builder().hunger(2).saturation(0.1f).setAlwaysEdible().damage(CrockPotDamageSource.POW_CAKE, 1.0f).build());
    public static final Item pumpkinCookie = CrockPotRegistry.register(ITEMS, "pumpkin_cookie", CrockPotFood.builder().hunger(10).saturation(0.7f).duration(FoodUseDuration.FAST).removePotion(Effects.field_76438_s).build());
    public static final Item ratatouille = CrockPotRegistry.register(ITEMS, "ratatouille", CrockPotFood.builder().hunger(6).saturation(0.4f).duration(FoodUseDuration.FAST).build());
    public static final Item salsa = CrockPotRegistry.register(ITEMS, "salsa", CrockPotFood.builder().hunger(7).saturation(0.8f).duration(FoodUseDuration.FAST).effect(Effects.field_76422_e, 7200).build());
    public static final Item seafoodGumbo = CrockPotRegistry.register(ITEMS, "seafood_gumbo", CrockPotFood.builder().hunger(9).saturation(0.7f).effect(Effects.field_76428_l, 2400).build());
    public static final Item stuffedEggplant = CrockPotRegistry.register(ITEMS, "stuffed_eggplant", CrockPotFood.builder().hunger(7).saturation(0.6f).duration(FoodUseDuration.FAST).heal(2.0f).build());
    public static final Item surfNTurf = CrockPotRegistry.register(ITEMS, "surf_n_turf", CrockPotFood.builder().hunger(8).saturation(1.2f).setAlwaysEdible().effect(Effects.field_76428_l, 600, 1).heal(8.0f).build());
    public static final Item taffy = CrockPotRegistry.register(ITEMS, "taffy", CrockPotFood.builder().hunger(5).saturation(0.4f).duration(FoodUseDuration.FAST).setAlwaysEdible().effect(Effects.field_188425_z, 9600).damage(CrockPotDamageSource.TAFFY, 1.0f).removePotion(Effects.field_76436_u).build());
    public static final Item tea = CrockPotRegistry.register(ITEMS, "tea", CrockPotFood.builder().hunger(3).saturation(0.6f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76422_e, 6000, 1).build());
    public static final Item tropicalBouillabaisse = CrockPotRegistry.register(ITEMS, "tropical_bouillabaisse", CrockPotFood.builder().hunger(7).saturation(0.6f).setAlwaysEdible().effect(Effects.field_206827_D, 6000).effect(Effects.field_76427_o, 6000).build());
    public static final Item turkeyDinner = CrockPotRegistry.register(ITEMS, "turkey_dinner", CrockPotFood.builder().hunger(12).saturation(0.8f).effect(Effects.field_180152_w, 3600).build());
    public static final Item vegStinger = CrockPotRegistry.register(ITEMS, "veg_stinger", CrockPotFood.builder().hunger(6).saturation(0.3f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76439_r, 12000).build());
    public static final Item watermelonIcle = CrockPotRegistry.register(ITEMS, "watermelon_icle", CrockPotFood.builder().hunger(5).saturation(0.4f).duration(FoodUseDuration.FAST).effect(Effects.field_76424_c, 3600).effect(Effects.field_76430_j, 3600).removePotion(Effects.field_76421_d).build());
    public static final Item wetGoop = CrockPotRegistry.register(ITEMS, "wet_goop", CrockPotFood.builder().hunger(0).saturation(0.0f).duration(FoodUseDuration.SUPER_SLOW).setAlwaysEdible().effect(Effects.field_76431_k, 200).tooltip("wet_goop", TextFormatting.ITALIC, TextFormatting.GRAY).build());
    public static final EnumMap<FoodCategory, Item> foodCategoryItems = new EnumMap<FoodCategory, Item>(FoodCategory.class){
        {
            for (FoodCategory category : EnumUtils.getEnumList(FoodCategory.class)) {
                this.put(category, CrockPotRegistry.register(ITEMS, "food_category_" + category.name().toLowerCase(), (IForgeRegistryEntry)new Item(new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP))));
            }
        }
    };

    private static <T extends IForgeRegistryEntry<T>, E extends T> E register(DeferredRegister<T> register, String name, E entry) {
        register.register(name, () -> entry);
        return entry;
    }
}

