/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.base;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.utils.JsonUtils;
import java.lang.reflect.Type;
import java.util.EnumMap;
import net.minecraft.util.JSONUtils;

public final class CategoryDefinitionTag {
    final String tag;
    final EnumMap<FoodCategory, Float> foodValue;

    public CategoryDefinitionTag(String tag, EnumMap<FoodCategory, Float> foodValue) {
        this.tag = tag;
        this.foodValue = foodValue;
    }

    public String getTag() {
        return this.tag;
    }

    public EnumMap<FoodCategory, Float> getValues() {
        return this.foodValue;
    }

    public static final class Serializer
    implements JsonSerializer<CategoryDefinitionTag>,
    JsonDeserializer<CategoryDefinitionTag> {
        public CategoryDefinitionTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            String tag = JSONUtils.func_151200_h((JsonObject)object, (String)"tag");
            EnumMap<FoodCategory, Float> foodValue = JsonUtils.getEnumMap(object, "values", FoodCategory.class, Float.class);
            return new CategoryDefinitionTag(tag, foodValue);
        }

        public JsonElement serialize(CategoryDefinitionTag src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("tag", src.tag);
            JsonObject foodValueJsonObject = new JsonObject();
            src.foodValue.forEach((k, v) -> foodValueJsonObject.addProperty(k.name(), (Number)v));
            object.add("values", (JsonElement)foodValueJsonObject);
            return object;
        }
    }
}

