/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.base;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sihenzhang.crockpot.base.CategoryDefinitionItem;
import com.sihenzhang.crockpot.base.CategoryDefinitionTag;
import com.sihenzhang.crockpot.base.FoodCategory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public final class FoodCategoryManager
extends JsonReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(CategoryDefinitionItem.class, (Object)new CategoryDefinitionItem.Serializer()).registerTypeAdapter(CategoryDefinitionTag.class, (Object)new CategoryDefinitionTag.Serializer()).create();
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<Item, CategoryDefinitionItem> itemDef = ImmutableMap.of();
    private Map<String, CategoryDefinitionTag> tagDef = ImmutableMap.of();

    public FoodCategoryManager() {
        super(GSON_INSTANCE, "crock_pot_food_values");
    }

    @Nonnull
    public EnumMap<FoodCategory, Float> valuesOf(Item item) {
        if (this.itemDef.containsKey(item)) {
            return this.itemDef.get(item).getValues();
        }
        EnumMap<FoodCategory, Float> values = new EnumMap<FoodCategory, Float>(FoodCategory.class);
        long maxCount = -1L;
        for (ResourceLocation tag : item.getTags()) {
            long count;
            String tagName = tag.toString();
            if (!this.tagDef.containsKey(tagName) || (count = tagName.chars().filter(c -> c == 47).count()) < maxCount) continue;
            if (count > maxCount) {
                maxCount = count;
                values.clear();
            }
            for (Map.Entry<FoodCategory, Float> category : this.tagDef.get(tagName).getValues().entrySet()) {
                values.put((FoodCategory)((Enum)category.getKey()), Float.valueOf(Math.max(values.getOrDefault((Object)category.getKey(), Float.valueOf(0.0f)).floatValue(), category.getValue().floatValue())));
            }
        }
        return values;
    }

    @Nonnull
    public Collection<Item> getMatchingItems(FoodCategory category, float value) {
        TreeSet<Item> items = new TreeSet<Item>((o1, o2) -> {
            ResourceLocation r1 = o1.getRegistryName();
            ResourceLocation r2 = o2.getRegistryName();
            String n1 = Objects.requireNonNull(r1).func_110624_b();
            String n2 = Objects.requireNonNull(r2).func_110624_b();
            if ("minecraft".equals(n1)) {
                return "minecraft".equals(n2) ? r1.compareTo(r2) : -1;
            }
            if ("minecraft".equals(n2)) {
                return 1;
            }
            if ("crockpot".equals(n1)) {
                return "crockpot".equals(n2) ? r1.compareTo(r2) : -1;
            }
            if ("crockpot".equals(n2)) {
                return 1;
            }
            return r1.compareTo(r2);
        });
        this.itemDef.forEach((item, categoryDefinitionItem) -> {
            if (categoryDefinitionItem.getValues().getOrDefault((Object)category, Float.valueOf(0.0f)).floatValue() == value) {
                items.add((Item)item);
            }
        });
        this.tagDef.forEach((tag, categoryDefinitionTag) -> {
            ITag itag;
            if (categoryDefinitionTag.getValues().getOrDefault((Object)category, Float.valueOf(0.0f)).floatValue() == value && (itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(tag))) != null) {
                Ingredient.TagList tagList = new Ingredient.TagList(itag);
                tagList.func_199799_a().forEach(stack -> {
                    Item item = stack.func_77973_b();
                    if (this.valuesOf(item).getOrDefault((Object)category, Float.valueOf(0.0f)).floatValue() == value) {
                        items.add(item);
                    }
                });
            }
        });
        return items;
    }

    public String serialize() {
        JsonArray defList = new JsonArray();
        this.itemDef.values().forEach(def -> {
            JsonObject o = GSON_INSTANCE.toJsonTree(def).getAsJsonObject();
            o.addProperty("type", "item");
            defList.add((JsonElement)o);
        });
        this.tagDef.values().forEach(def -> {
            JsonObject o = GSON_INSTANCE.toJsonTree(def).getAsJsonObject();
            o.addProperty("type", "tag");
            defList.add((JsonElement)o);
        });
        return defList.toString();
    }

    public void deserialize(String str) {
        JsonArray array = (JsonArray)GSON_INSTANCE.fromJson(str, JsonArray.class);
        HashMap<Item, Object> itemDef = new HashMap<Item, Object>(16);
        HashMap<String, Object> tagDef = new HashMap<String, Object>(16);
        for (JsonElement e : array) {
            JsonObject o = e.getAsJsonObject();
            switch (Objects.requireNonNull(JSONUtils.func_151200_h((JsonObject)o, (String)"type"))) {
                case "item": {
                    Object def = (CategoryDefinitionItem)GSON_INSTANCE.fromJson((JsonElement)o, CategoryDefinitionItem.class);
                    if (((CategoryDefinitionItem)def).item == null) break;
                    if (itemDef.containsKey(((CategoryDefinitionItem)def).item)) {
                        throw new RuntimeException("Duplicate item definition");
                    }
                    itemDef.put(((CategoryDefinitionItem)def).item, def);
                    break;
                }
                case "tag": {
                    Object def = (CategoryDefinitionTag)GSON_INSTANCE.fromJson((JsonElement)o, CategoryDefinitionTag.class);
                    if (tagDef.containsKey(((CategoryDefinitionTag)def).tag)) {
                        throw new RuntimeException("Duplicate tag definition");
                    }
                    tagDef.put(((CategoryDefinitionTag)def).tag, def);
                    break;
                }
            }
        }
        this.itemDef = ImmutableMap.copyOf(itemDef);
        this.tagDef = ImmutableMap.copyOf(tagDef);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        LOGGER.info("Start loading food categories");
        HashMap<Item, Object> itemDef = new HashMap<Item, Object>(16);
        HashMap<String, Object> tagDef = new HashMap<String, Object>(16);
        block10: for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.func_110623_a().startsWith("_")) continue;
            try {
                JsonObject o = entry.getValue().getAsJsonObject();
                switch (Objects.requireNonNull(JSONUtils.func_151200_h((JsonObject)o, (String)"type"))) {
                    case "item": {
                        Object def = (CategoryDefinitionItem)GSON_INSTANCE.fromJson((JsonElement)o, CategoryDefinitionItem.class);
                        if (((CategoryDefinitionItem)def).item == null) continue block10;
                        if (itemDef.containsKey(((CategoryDefinitionItem)def).item)) {
                            throw new IllegalArgumentException("Duplicate definition for item " + ((CategoryDefinitionItem)def).item.getRegistryName());
                        }
                        itemDef.put(((CategoryDefinitionItem)def).item, def);
                        break;
                    }
                    case "tag": {
                        Object def = (CategoryDefinitionTag)GSON_INSTANCE.fromJson((JsonElement)o, CategoryDefinitionTag.class);
                        if (tagDef.containsKey(((CategoryDefinitionTag)def).tag)) {
                            throw new IllegalArgumentException("Duplicate definition for tag: " + ((CategoryDefinitionTag)def).tag);
                        }
                        tagDef.put(((CategoryDefinitionTag)def).tag, def);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid definition type");
                    }
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Parsing error loading crock pot food category {}", (Object)resourceLocation, (Object)exception);
            }
        }
        this.itemDef = ImmutableMap.copyOf(itemDef);
        this.tagDef = ImmutableMap.copyOf(tagDef);
        LOGGER.info("Categories loading complete.");
    }
}

