/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import com.sihenzhang.crockpot.block.CrockPotDoubleCropsBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrockPotUnknownCropsBlock
extends CrockPotCropsBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_222512_Y;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};
    private static volatile List<Block> CROPS_BLOCKS = null;

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.func_185524_e())];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static List<Block> getCropsBlocks() {
        if (CROPS_BLOCKS != null) return CROPS_BLOCKS;
        Class<CrockPotUnknownCropsBlock> clazz = CrockPotUnknownCropsBlock.class;
        synchronized (CrockPotUnknownCropsBlock.class) {
            if (CROPS_BLOCKS != null) return CROPS_BLOCKS;
            ArrayList<Block> tmp = new ArrayList<Block>();
            for (String key : (List)CrockPotConfig.UNKNOWN_SEEDS_CROPS_LIST.get()) {
                BlockItem blockItem;
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key));
                BlockItem blockItem2 = blockItem = item instanceof BlockItem ? (BlockItem)item : null;
                if (blockItem != null && blockItem.func_179223_d() instanceof IPlantable) {
                    tmp.add(blockItem.func_179223_d());
                    continue;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block == null || block == Blocks.field_150350_a) continue;
                tmp.add(block);
            }
            CROPS_BLOCKS = tmp;
            // ** MonitorExit[var0] (shouldn't be in output)
            return CROPS_BLOCKS;
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        float growthChance;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthChance = CrockPotUnknownCropsBlock.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, CrockPotUnknownCropsBlock.getCropsBlocks().get(random.nextInt(CrockPotUnknownCropsBlock.getCropsBlocks().size())).func_176223_P(), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        Block block = CrockPotUnknownCropsBlock.getCropsBlocks().get(worldIn.field_73012_v.nextInt(CrockPotUnknownCropsBlock.getCropsBlocks().size()));
        int age = this.func_185529_b(worldIn) - 1;
        if (block instanceof CrockPotDoubleCropsBlock) {
            CrockPotDoubleCropsBlock cropsBlock = (CrockPotDoubleCropsBlock)block;
            int maxAge = cropsBlock.getMaxGrowthAge(cropsBlock.func_176223_P());
            if (age > maxAge) {
                worldIn.func_180501_a(pos, cropsBlock.func_185528_e(maxAge), 2);
                if (worldIn.func_175623_d(pos.func_177984_a())) {
                    worldIn.func_180501_a(pos.func_177984_a(), cropsBlock.func_185528_e(age), 2);
                }
            } else {
                worldIn.func_180501_a(pos, cropsBlock.func_185528_e(age), 2);
            }
        } else if (block instanceof CropsBlock) {
            CropsBlock cropsBlock = (CropsBlock)block;
            worldIn.func_180501_a(pos, cropsBlock.func_185528_e(Math.min(age, cropsBlock.func_185526_g())), 2);
        }
        worldIn.func_180501_a(pos, block.func_176223_P(), 2);
    }

    @Override
    protected IItemProvider func_199772_f() {
        return CrockPotRegistry.unknownSeeds;
    }
}

