/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.FoodCategory;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CategoryTooltip {
    private static final IFormattableTextComponent DELIMITER = new StringTextComponent(", ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"white")));

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().func_77973_b();
        EnumMap<FoodCategory, Float> values = CrockPot.FOOD_CATEGORY_MANAGER.valuesOf(item);
        if (!values.isEmpty()) {
            IFormattableTextComponent tooltip = null;
            for (Map.Entry<FoodCategory, Float> category : values.entrySet()) {
                IFormattableTextComponent categoryText = new StringTextComponent(I18n.func_135052_a((String)("item.crockpot.food_category_" + category.getKey().name().toLowerCase()), (Object[])new Object[0]) + ": " + category.getValue()).func_230530_a_(Style.field_240709_b_.func_240718_a_(category.getKey().color));
                if (tooltip == null) {
                    tooltip = categoryText;
                    continue;
                }
                tooltip.func_230529_a_((ITextComponent)DELIMITER).func_230529_a_((ITextComponent)categoryText);
            }
            event.getToolTip().add(tooltip);
        }
    }
}

