/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.base.FoodCategory;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.EnumUtils;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber(modid="crockpot")
public class ModIntegrationPatchouli {
    public static final String MOD_ID = "patchouli";

    @SubscribeEvent
    public static void addConfigFlag(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }

            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                if (ModList.get().isLoaded(ModIntegrationPatchouli.MOD_ID)) {
                    EnumUtils.getEnumList(FoodCategory.class).forEach(category -> {
                        for (float value = 0.25f; value <= 4.0f; value += 0.25f) {
                            ModIntegrationPatchouli.setConfigFlag(category.name().toLowerCase() + ":" + value, !CrockPot.FOOD_CATEGORY_MANAGER.getMatchingItems((FoodCategory)((Object)category), value).isEmpty());
                        }
                    });
                    ModIntegrationPatchouli.setConfigFlag("unknown_seeds", (Boolean)CrockPotConfig.ENABLE_UNKNOWN_SEEDS.get());
                    ModIntegrationPatchouli.setConfigFlag("world_gen", (Boolean)CrockPotConfig.ENABLE_WORLD_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("asparagus_gen", (Boolean)CrockPotConfig.ASPARAGUS_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("corn_gen", (Boolean)CrockPotConfig.CORN_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("eggplant_gen", (Boolean)CrockPotConfig.EGGPLANT_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("onion_gen", (Boolean)CrockPotConfig.ONION_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("pepper_gen", (Boolean)CrockPotConfig.PEPPER_GENERATION.get());
                    ModIntegrationPatchouli.setConfigFlag("tomato_gen", (Boolean)CrockPotConfig.TOMATO_GENERATION.get());
                }
            }
        });
    }

    private static void setConfigFlag(String key, boolean value) {
        PatchouliAPI.instance.setConfigFlag("crockpot:" + key, value);
    }
}

