/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrockPotBlockItem
extends BlockItem {
    private final Random rand = new Random();
    private long lastSysTime;
    private final Set<Integer> toPick = new HashSet<Integer>();
    private final String[] suffixes = new String[]{"Pro", "Plus", "Max", "Ultra", "Premium", "Super"};

    public CrockPotBlockItem(Block blockIn) {
        super(blockIn, new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        int potLevel = ((CrockPotBlock)this.func_179223_d()).getPotLevel();
        if (potLevel > 0) {
            long sysTime = System.currentTimeMillis();
            if (this.lastSysTime + 5000L < sysTime) {
                this.lastSysTime = sysTime;
                this.toPick.clear();
                while (this.toPick.size() < potLevel) {
                    this.toPick.add(this.rand.nextInt(this.suffixes.length));
                }
            }
            ITextComponent[] toPickSuffixes = (ITextComponent[])this.toPick.stream().map(i -> new StringTextComponent(this.suffixes[i])).toArray(ITextComponent[]::new);
            return new TranslationTextComponent(this.func_77667_c(stack), (Object[])toPickSuffixes);
        }
        return super.func_200295_i(stack);
    }
}

