/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementUtil;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
public class Recipe
implements INBTSerializable<CompoundNBT>,
Predicate<RecipeInput> {
    List<Requirement> requirements = new ArrayList<Requirement>();
    int priority;
    int weight;
    int cookTime;
    int potLevel;
    ItemStack result;
    public static final Recipe EMPTY = new Recipe(0, 0, 0, 0, ItemStack.field_190927_a);

    public Recipe(int priority, int weight, int cookTime, int potLevel, ItemStack result) {
        this.priority = priority;
        this.weight = weight;
        this.result = result;
        this.cookTime = cookTime;
        this.potLevel = potLevel;
    }

    public boolean isEmpty() {
        return this.result.func_190926_b();
    }

    public Recipe(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT req = new ListNBT();
        this.requirements.stream().map(INBTSerializable::serializeNBT).forEach(arg_0 -> req.add(arg_0));
        nbt.func_218657_a("requirements", (INBT)req);
        nbt.func_74768_a("priority", this.priority);
        nbt.func_74768_a("weight", this.weight);
        nbt.func_218657_a("result", (INBT)this.result.serializeNBT());
        nbt.func_74768_a("cookTime", this.cookTime);
        nbt.func_74768_a("potLevel", this.potLevel);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.priority = nbt.func_74762_e("priority");
        this.weight = nbt.func_74762_e("weight");
        this.cookTime = nbt.func_74762_e("cookTime");
        this.potLevel = nbt.func_74762_e("potLevel");
        this.result = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)Objects.requireNonNull(nbt.func_74781_a("result"))));
        ListNBT requirements = (ListNBT)nbt.func_74781_a("requirements");
        assert (requirements != null);
        requirements.stream().map(RequirementUtil::deserialize).forEach(this.requirements::add);
    }

    @Override
    public boolean test(RecipeInput recipeInput) {
        return recipeInput.potLevel >= this.potLevel && this.requirements.stream().allMatch(r -> r.test(recipeInput));
    }

    public static class Serializer
    implements JsonDeserializer<Recipe>,
    JsonSerializer<Recipe> {
        public Recipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new Recipe(JsonToNBT.func_180713_a((String)json.toString()));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }

        public JsonElement serialize(Recipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonReader reader = new JsonReader((Reader)new StringReader(src.serializeNBT().toString()));
            reader.setLenient(true);
            return new JsonParser().parse(reader);
        }
    }
}

