/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.requirements;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementType;
import com.sihenzhang.crockpot.utils.NbtUtils;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;

public class RequirementMustContainIngredient
extends Requirement {
    Ingredient ingredient;
    int quantity;

    public RequirementMustContainIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = ingredient;
        this.quantity = quantity;
    }

    public RequirementMustContainIngredient(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public boolean test(RecipeInput recipeInput) {
        return recipeInput.stacks.stream().filter(stack -> this.ingredient.test(stack)).count() >= (long)this.quantity;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", RequirementType.MUST_CONTAIN_INGREDIENT.name().toLowerCase());
        try {
            nbt.func_218657_a("ingredient", NbtUtils.writeIngredient(this.ingredient));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        nbt.func_74768_a("quantity", this.quantity);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (!RequirementType.MUST_CONTAIN_INGREDIENT.name().equals(nbt.func_74779_i("type").toUpperCase())) {
            throw new IllegalArgumentException("Requirement type doesn't match");
        }
        this.ingredient = NbtUtils.readIngredient(nbt.func_74781_a("ingredient"));
        this.quantity = nbt.func_74762_e("quantity");
    }
}

