/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.requirements;

import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCombinationAnd;
import com.sihenzhang.crockpot.recipe.requirements.RequirementCombinationOr;
import com.sihenzhang.crockpot.recipe.requirements.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.requirements.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.recipe.requirements.RequirementType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public final class RequirementUtil {
    public static Requirement deserialize(INBT nbtIn) {
        CompoundNBT nbt = (CompoundNBT)nbtIn;
        switch (RequirementType.valueOf(nbt.func_74779_i("type").toUpperCase())) {
            case COMBINATION_AND: {
                return new RequirementCombinationAnd(nbt);
            }
            case COMBINATION_OR: {
                return new RequirementCombinationOr(nbt);
            }
            case CATEGORY_MAX: {
                return new RequirementCategoryMax(nbt);
            }
            case CATEGORY_MAX_EXCLUSIVE: {
                return new RequirementCategoryMaxExclusive(nbt);
            }
            case CATEGORY_MIN: {
                return new RequirementCategoryMin(nbt);
            }
            case CATEGORY_MIN_EXCLUSIVE: {
                return new RequirementCategoryMinExclusive(nbt);
            }
            case MUST_CONTAIN_INGREDIENT: {
                return new RequirementMustContainIngredient(nbt);
            }
            case MUST_CONTAIN_INGREDIENT_LESS_THAN: {
                return new RequirementMustContainIngredientLessThan(nbt);
            }
        }
        throw new IllegalArgumentException("No valid type found");
    }
}

