/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;

public final class JsonUtils {
    private static final Gson GSON = new GsonBuilder().create();

    @Nullable
    public static Item getItem(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String s = json.getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            return item == Items.field_190931_a ? null : item;
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + JSONUtils.func_151222_d((JsonElement)json));
    }

    @Nullable
    public static Item getItem(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonUtils.getItem(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    @Nonnull
    public static <K extends Enum<K>, V> EnumMap<K, V> getEnumMap(JsonElement json, String memberName, Class<K> enumClass, Class<V> valueClass) {
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            EnumMap enumMap = new EnumMap(enumClass);
            o.entrySet().forEach(e -> {
                String enumName = (String)e.getKey();
                if (!EnumUtils.isValidEnum((Class)enumClass, (String)enumName.toUpperCase())) {
                    throw new JsonSyntaxException("Expected the key of " + memberName + " to be a " + enumClass.getSimpleName() + ", was unknown " + enumClass.getSimpleName() + " name '" + enumName + "'");
                }
                enumMap.put((Object)EnumUtils.getEnum((Class)enumClass, (String)enumName.toUpperCase()), GSON.fromJson((JsonElement)e.getValue(), valueClass));
            });
            return enumMap;
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an enum map, was " + JSONUtils.func_151222_d((JsonElement)json));
    }

    @Nonnull
    public static <K extends Enum<K>, V> EnumMap<K, V> getEnumMap(JsonObject json, String memberName, Class<K> enumClass, Class<V> valueClass) {
        if (json.has(memberName)) {
            return JsonUtils.getEnumMap(json.get(memberName), memberName, enumClass, valueClass);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an enum map");
    }
}

