/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot;

import com.google.common.collect.ImmutableSet;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.CornBlock;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import com.sihenzhang.crockpot.block.CrockPotUnknownCropsBlock;
import com.sihenzhang.crockpot.container.CrockPotContainer;
import com.sihenzhang.crockpot.effect.CrockPotEffect;
import com.sihenzhang.crockpot.item.CollectedDustItem;
import com.sihenzhang.crockpot.item.CreativeMilkmadeHatItem;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotSeedsItem;
import com.sihenzhang.crockpot.item.CrockPotUnknownSeedsItem;
import com.sihenzhang.crockpot.item.GnawsCoinItem;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.item.NetherosiaItem;
import com.sihenzhang.crockpot.item.food.Candy;
import com.sihenzhang.crockpot.item.food.CrockPotFood;
import com.sihenzhang.crockpot.item.food.FlowerSalad;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCream;
import com.sihenzhang.crockpot.loot.CrockPotUnknownSeedsDropModifier;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import com.sihenzhang.crockpot.world.CrockPotCropsFeature;
import com.sihenzhang.crockpot.world.CrockPotCropsFeatureConfig;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class CrockPotRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crockpot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"crockpot");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"crockpot");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"crockpot");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"crockpot");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"crockpot");
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"crockpot");
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"crockpot");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"crockpot");
    public static final Effect gnawsGift = CrockPotRegistry.register(EFFECTS, "gnaws_gift", new CrockPotEffect(EffectType.BENEFICIAL, 6621192));
    public static final Effect oceanAffinity = CrockPotRegistry.register(EFFECTS, "ocean_affinity", new CrockPotEffect(EffectType.BENEFICIAL, 1433076));
    public static final Effect wellFed = CrockPotRegistry.register(EFFECTS, "well_fed", new CrockPotEffect(EffectType.BENEFICIAL, 14317147).func_220304_a(Attributes.field_233826_i_, "095FA141-E902-4BEF-99DB-DDC55213C07A", 1.0, AttributeModifier.Operation.ADDITION).func_220304_a(Attributes.field_233823_f_, "5762F89C-8317-4021-B7EE-4DD93902941C", 1.0, AttributeModifier.Operation.ADDITION));
    public static final Effect witherResistanceEffect = CrockPotRegistry.register(EFFECTS, "wither_resistance", new CrockPotEffect(EffectType.BENEFICIAL, 7471247));
    public static final IRecipeSerializer<CrockPotCookingRecipe> crockPotCooking = CrockPotRegistry.register(RECIPE_SERIALIZERS, "crock_pot_cooking", new CrockPotCookingRecipe.Serializer());
    public static final IRecipeSerializer<ExplosionCraftingRecipe> explosionCrafting = CrockPotRegistry.register(RECIPE_SERIALIZERS, "explosion_crafting", new ExplosionCraftingRecipe.Serializer());
    public static final IRecipeSerializer<FoodValuesDefinition> foodValues = CrockPotRegistry.register(RECIPE_SERIALIZERS, "food_values", new FoodValuesDefinition.Serializer());
    public static final IRecipeSerializer<PiglinBarteringRecipe> piglinBartering = CrockPotRegistry.register(RECIPE_SERIALIZERS, "piglin_bartering", new PiglinBarteringRecipe.Serializer());
    public static final Block crockPotBasicBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_basic", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 0;
        }
    });
    public static final Item crockPotBasicBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_basic", new CrockPotBlockItem(crockPotBasicBlock));
    public static final Block crockPotAdvancedBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_advanced", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 1;
        }
    });
    public static final Item crockPotAdvancedBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_advanced", new CrockPotBlockItem(crockPotAdvancedBlock));
    public static final Block crockPotUltimateBlock = CrockPotRegistry.register(BLOCKS, "crock_pot_ultimate", new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 2;
        }
    });
    public static final Item crockPotUltimateBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_ultimate", new CrockPotBlockItem(crockPotUltimateBlock));
    public static final TileEntityType<CrockPotTileEntity> crockPotTileEntity = CrockPotRegistry.register(TILE_ENTITIES, "crock_pot", TileEntityType.Builder.func_223042_a(CrockPotTileEntity::new, (Block[])new Block[]{crockPotBasicBlock, crockPotAdvancedBlock, crockPotUltimateBlock}).func_206865_a(null));
    public static final ContainerType<CrockPotContainer> crockPotContainer = CrockPotRegistry.register(CONTAINERS, "crock_pot", IForgeContainerType.create((windowId, inv, data) -> {
        BlockPos pos = data.func_179259_c();
        return new CrockPotContainer(windowId, inv, (CrockPotTileEntity)inv.field_70458_d.field_70170_p.func_175625_s(pos));
    }));
    public static final GlobalLootModifierSerializer<CrockPotUnknownSeedsDropModifier> unknownSeedsDropModifier = CrockPotRegistry.register(LOOT_MODIFIER_SERIALIZERS, "unknown_seeds_drop", new CrockPotUnknownSeedsDropModifier.Serializer());
    public static final Block unknownCropsBlock = (Block)CrockPotRegistry.register(BLOCKS, "unknown_crops", new CrockPotUnknownCropsBlock());
    public static final Item unknownSeeds = (Item)CrockPotRegistry.register(ITEMS, "unknown_seeds", new CrockPotUnknownSeedsItem());
    public static final Feature<CrockPotCropsFeatureConfig> cropsPatchFeature = CrockPotRegistry.register(FEATURES, "crops_patch", new CrockPotCropsFeature(CrockPotCropsFeatureConfig.CODEC));
    public static final Block asparagusBlock = (Block)CrockPotRegistry.register(BLOCKS, "asparaguses", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return asparagusSeeds;
        }
    });
    public static final Item asparagusSeeds = (Item)CrockPotRegistry.register(ITEMS, "asparagus_seeds", new CrockPotSeedsItem(asparagusBlock));
    public static final Item asparagus = CrockPotRegistry.register(ITEMS, "asparagus", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Block cornBlock = (Block)CrockPotRegistry.register(BLOCKS, "corns", new CornBlock());
    public static final Item cornSeeds = (Item)CrockPotRegistry.register(ITEMS, "corn_seeds", new CrockPotSeedsItem(cornBlock));
    public static final Item corn = CrockPotRegistry.register(ITEMS, "corn", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Item popcorn = CrockPotRegistry.register(ITEMS, "popcorn", CrockPotFood.builder().nutrition(3).saturationMod(0.8f).duration(FoodUseDuration.FAST).hideEffects().build());
    public static final Block eggplantBlock = (Block)CrockPotRegistry.register(BLOCKS, "eggplants", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return eggplantSeeds;
        }
    });
    public static final Item eggplantSeeds = (Item)CrockPotRegistry.register(ITEMS, "eggplant_seeds", new CrockPotSeedsItem(eggplantBlock));
    public static final Item eggplant = CrockPotRegistry.register(ITEMS, "eggplant", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Item cookedEggplant = CrockPotRegistry.register(ITEMS, "cooked_eggplant", CrockPotFood.builder().nutrition(5).saturationMod(0.6f).hideEffects().build());
    public static final Block onionBlock = (Block)CrockPotRegistry.register(BLOCKS, "onions", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return onionSeeds;
        }
    });
    public static final Item onionSeeds = (Item)CrockPotRegistry.register(ITEMS, "onion_seeds", new CrockPotSeedsItem(onionBlock));
    public static final Item onion = CrockPotRegistry.register(ITEMS, "onion", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Block pepperBlock = (Block)CrockPotRegistry.register(BLOCKS, "peppers", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return pepperSeeds;
        }
    });
    public static final Item pepperSeeds = (Item)CrockPotRegistry.register(ITEMS, "pepper_seeds", new CrockPotSeedsItem(pepperBlock));
    public static final Item pepper = CrockPotRegistry.register(ITEMS, "pepper", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).damage(CrockPotDamageSource.SPICY, 1.0f).hideEffects().build());
    public static final Block tomatoBlock = (Block)CrockPotRegistry.register(BLOCKS, "tomatoes", new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return tomatoSeeds;
        }
    });
    public static final Item tomatoSeeds = (Item)CrockPotRegistry.register(ITEMS, "tomato_seeds", new CrockPotSeedsItem(tomatoBlock));
    public static final Item tomato = CrockPotRegistry.register(ITEMS, "tomato", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Set<Item> seeds = ImmutableSet.of((Object)unknownSeeds, (Object)asparagusSeeds, (Object)cornSeeds, (Object)eggplantSeeds, (Object)onionSeeds, (Object)pepperSeeds, (Object[])new Item[]{tomatoSeeds});
    public static final Set<Item> crops = ImmutableSet.of((Object)asparagus, (Object)corn, (Object)eggplant, (Object)onion, (Object)pepper, (Object)tomato, (Object[])new Item[0]);
    public static final Set<Item> cookedCrops = ImmutableSet.of((Object)popcorn, (Object)cookedEggplant);
    public static final Item blackstoneDust = CrockPotRegistry.register(ITEMS, "blackstone_dust", new Item(new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP)));
    public static final Item collectedDust = CrockPotRegistry.register(ITEMS, "collected_dust", new CollectedDustItem());
    public static final Item cookedEgg = CrockPotRegistry.register(ITEMS, "cooked_egg", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Item frogLegs = CrockPotRegistry.register(ITEMS, "frog_legs", CrockPotFood.builder().nutrition(2).saturationMod(0.4f).meat().hideEffects().build());
    public static final Item cookedFrogLegs = CrockPotRegistry.register(ITEMS, "cooked_frog_legs", CrockPotFood.builder().nutrition(5).saturationMod(0.7f).meat().hideEffects().build());
    public static final Item hoglinNose = CrockPotRegistry.register(ITEMS, "hoglin_nose", CrockPotFood.builder().nutrition(3).saturationMod(0.2f).meat().hideEffects().build());
    public static final Item cookedHoglinNose = CrockPotRegistry.register(ITEMS, "cooked_hoglin_nose", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).meat().hideEffects().build());
    public static final Item milkBottle = CrockPotRegistry.register(ITEMS, "milk_bottle", CrockPotFood.builder().nutrition(0).saturationMod(0.0f).alwaysEat().drink().tooltip("milk_bottle", TextFormatting.DARK_AQUA).hideEffects().build());
    public static final Item syrup = CrockPotRegistry.register(ITEMS, "syrup", CrockPotFood.builder().nutrition(1).saturationMod(0.3f).drink().hideEffects().build());
    public static final Item milkmadeHat = CrockPotRegistry.register(ITEMS, "milkmade_hat", new MilkmadeHatItem());
    public static final Item creativeMilkmadeHat = CrockPotRegistry.register(ITEMS, "creative_milkmade_hat", new CreativeMilkmadeHatItem());
    public static final Item gnawsCoin = CrockPotRegistry.register(ITEMS, "gnaws_coin", new GnawsCoinItem());
    public static final Item asparagusSoup = CrockPotRegistry.register(ITEMS, "asparagus_soup", CrockPotFood.builder().nutrition(4).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().removeEffect(Effects.field_76437_t).removeEffect(Effects.field_76419_f).removeEffect(Effects.field_76440_q).removeEffect(Effects.field_220309_E).build());
    public static final Item avaj = CrockPotRegistry.register(ITEMS, "avaj", CrockPotFood.builder().nutrition(2).saturationMod(3.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(Effects.field_76424_c, 38800, 2).hide().rarity(Rarity.EPIC).build());
    public static final Item baconEggs = CrockPotRegistry.register(ITEMS, "bacon_eggs", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).heal(4.0f).build());
    public static final Item boneSoup = CrockPotRegistry.register(ITEMS, "bone_soup", CrockPotFood.builder().nutrition(10).saturationMod(0.6f).effect(Effects.field_76444_x, 2400, 1).build());
    public static final Item boneStew = CrockPotRegistry.register(ITEMS, "bone_stew", CrockPotFood.builder().nutrition(20).saturationMod(0.4f).duration(FoodUseDuration.SUPER_SLOW).effect(Effects.field_76432_h, 1, 1).build());
    public static final Item bunnyStew = CrockPotRegistry.register(ITEMS, "bunny_stew", CrockPotFood.builder().nutrition(6).saturationMod(0.8f).effect(Effects.field_76428_l, 100).effect(wellFed, 3600).build());
    public static final Item californiaRoll = CrockPotRegistry.register(ITEMS, "california_roll", CrockPotFood.builder().nutrition(10).saturationMod(0.6f).heal(4.0f).effect(Effects.field_76444_x, 1200).build());
    public static final Item candy = CrockPotRegistry.register(ITEMS, "candy", new Candy());
    public static final Item ceviche = CrockPotRegistry.register(ITEMS, "ceviche", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).alwaysEat().effect(Effects.field_76429_m, 400, 1).effect(Effects.field_76444_x, 400, 1).build());
    public static final Item fishSticks = CrockPotRegistry.register(ITEMS, "fish_sticks", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).effect(Effects.field_76428_l, 600).build());
    public static final Item fishTacos = CrockPotRegistry.register(ITEMS, "fish_tacos", CrockPotFood.builder().nutrition(8).saturationMod(0.9f).heal(2.0f).build());
    public static final Item flowerSalad = CrockPotRegistry.register(ITEMS, "flower_salad", new FlowerSalad());
    public static final Item froggleBunwich = CrockPotRegistry.register(ITEMS, "froggle_bunwich", CrockPotFood.builder().nutrition(7).saturationMod(0.8f).build());
    public static final Item fruitMedley = CrockPotRegistry.register(ITEMS, "fruit_medley", CrockPotFood.builder().nutrition(8).saturationMod(0.4f).effect(Effects.field_76424_c, 3600).build());
    public static final Item gazpacho = CrockPotRegistry.register(ITEMS, "gazpacho", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(Effects.field_76426_n, 12000).build());
    public static final Item honeyHam = CrockPotRegistry.register(ITEMS, "honey_ham", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).effect(Effects.field_76428_l, 400).effect(Effects.field_76444_x, 1200, 1).heal(6.0f).build());
    public static final Item honeyNuggets = CrockPotRegistry.register(ITEMS, "honey_nuggets", CrockPotFood.builder().nutrition(8).saturationMod(0.3f).effect(Effects.field_76428_l, 200).effect(Effects.field_76444_x, 1200).heal(4.0f).build());
    public static final Item hotChili = CrockPotRegistry.register(ITEMS, "hot_chili", CrockPotFood.builder().nutrition(9).saturationMod(0.8f).effect(Effects.field_76420_g, 1800).effect(Effects.field_76422_e, 1800).build());
    public static final Item hotCocoa = CrockPotRegistry.register(ITEMS, "hot_cocoa", CrockPotFood.builder().nutrition(2).saturationMod(0.1f).alwaysEat().drink().effect(Effects.field_76424_c, 9600, 1).removeEffect(Effects.field_76421_d).removeEffect(Effects.field_76419_f).build());
    public static final Item iceCream = CrockPotRegistry.register(ITEMS, "ice_cream", new IceCream());
    public static final Item icedTea = CrockPotRegistry.register(ITEMS, "iced_tea", CrockPotFood.builder().nutrition(3).saturationMod(0.1f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76430_j, 6000, 1).build());
    public static final Item jammyPreserves = CrockPotRegistry.register(ITEMS, "jammy_preserves", CrockPotFood.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).build());
    public static final Item kabobs = CrockPotRegistry.register(ITEMS, "kabobs", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).build());
    public static final Item meatBalls = CrockPotRegistry.register(ITEMS, "meat_balls", CrockPotFood.builder().nutrition(9).saturationMod(0.5f).build());
    public static final Item monsterLasagna = CrockPotRegistry.register(ITEMS, "monster_lasagna", CrockPotFood.builder().nutrition(7).saturationMod(0.2f).effect(Effects.field_76438_s, 300).effect(Effects.field_76436_u, 40).damage(CrockPotDamageSource.MONSTER_FOOD, 6.0f).build());
    public static final Item monsterTartare = CrockPotRegistry.register(ITEMS, "monster_tartare", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).effect(Effects.field_76420_g, 2400, 1).build());
    public static final Item moqueca = CrockPotRegistry.register(ITEMS, "moqueca", CrockPotFood.builder().nutrition(14).saturationMod(0.7f).duration(FoodUseDuration.SLOW).effect(Effects.field_180152_w, 1800, 2).heal(6.0f).build());
    public static final Item mushyCake = CrockPotRegistry.register(ITEMS, "mushy_cake", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(witherResistanceEffect, 1200).build());
    public static final Item netherosia = CrockPotRegistry.register(ITEMS, "netherosia", new NetherosiaItem());
    public static final Item pepperPopper = CrockPotRegistry.register(ITEMS, "pepper_popper", CrockPotFood.builder().nutrition(8).saturationMod(0.8f).effect(Effects.field_76420_g, 1200, 1).build());
    public static final Item perogies = CrockPotRegistry.register(ITEMS, "perogies", CrockPotFood.builder().nutrition(8).saturationMod(0.8f).heal(6.0f).build());
    public static final Item potatoSouffle = CrockPotRegistry.register(ITEMS, "potato_souffle", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).effect(Effects.field_76429_m, 1800, 1).build());
    public static final Item potatoTornado = CrockPotRegistry.register(ITEMS, "potato_tornado", CrockPotFood.builder().nutrition(8).saturationMod(0.6f).duration(FoodUseDuration.FAST).removeEffect(Effects.field_76438_s).build());
    public static final Item powCake = CrockPotRegistry.register(ITEMS, "pow_cake", CrockPotFood.builder().nutrition(2).saturationMod(0.1f).alwaysEat().damage(CrockPotDamageSource.POW_CAKE, 1.0f).build());
    public static final Item pumpkinCookie = CrockPotRegistry.register(ITEMS, "pumpkin_cookie", CrockPotFood.builder().nutrition(10).saturationMod(0.7f).duration(FoodUseDuration.FAST).removeEffect(Effects.field_76438_s).build());
    public static final Item ratatouille = CrockPotRegistry.register(ITEMS, "ratatouille", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).build());
    public static final Item salmonSushi = CrockPotRegistry.register(ITEMS, "salmon_sushi", CrockPotFood.builder().nutrition(5).saturationMod(0.8f).duration(FoodUseDuration.FAST).heal(1.0f).build());
    public static final Item salsa = CrockPotRegistry.register(ITEMS, "salsa", CrockPotFood.builder().nutrition(7).saturationMod(0.8f).duration(FoodUseDuration.FAST).effect(Effects.field_76422_e, 7200).build());
    public static final Item seafoodGumbo = CrockPotRegistry.register(ITEMS, "seafood_gumbo", CrockPotFood.builder().nutrition(9).saturationMod(0.7f).effect(Effects.field_76428_l, 2400).build());
    public static final Item stuffedEggplant = CrockPotRegistry.register(ITEMS, "stuffed_eggplant", CrockPotFood.builder().nutrition(7).saturationMod(0.6f).duration(FoodUseDuration.FAST).heal(2.0f).build());
    public static final Item surfNTurf = CrockPotRegistry.register(ITEMS, "surf_n_turf", CrockPotFood.builder().nutrition(8).saturationMod(1.2f).alwaysEat().effect(Effects.field_76428_l, 600, 1).heal(8.0f).build());
    public static final Item taffy = CrockPotRegistry.register(ITEMS, "taffy", CrockPotFood.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(Effects.field_188425_z, 9600).damage(CrockPotDamageSource.TAFFY, 1.0f).removeEffect(Effects.field_76436_u).build());
    public static final Item tea = CrockPotRegistry.register(ITEMS, "tea", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76422_e, 6000, 1).build());
    public static final Item tropicalBouillabaisse = CrockPotRegistry.register(ITEMS, "tropical_bouillabaisse", CrockPotFood.builder().nutrition(7).saturationMod(0.6f).alwaysEat().effect(oceanAffinity, 3000).build());
    public static final Item turkeyDinner = CrockPotRegistry.register(ITEMS, "turkey_dinner", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).effect(Effects.field_180152_w, 3600).build());
    public static final Item vegStinger = CrockPotRegistry.register(ITEMS, "veg_stinger", CrockPotFood.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(Effects.field_76439_r, 12000).build());
    public static final Item watermelonIcle = CrockPotRegistry.register(ITEMS, "watermelon_icle", CrockPotFood.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).effect(Effects.field_76424_c, 3600).effect(Effects.field_76430_j, 3600).removeEffect(Effects.field_76421_d).build());
    public static final Item wetGoop = CrockPotRegistry.register(ITEMS, "wet_goop", CrockPotFood.builder().nutrition(0).saturationMod(0.0f).duration(FoodUseDuration.SUPER_SLOW).alwaysEat().effect(Effects.field_76431_k, 200).tooltip("wet_goop", TextFormatting.DARK_AQUA).build());
    public static final Map<FoodCategory, Item> foodCategoryItems = (Map)Util.func_200696_a(new EnumMap(FoodCategory.class), map -> {
        for (FoodCategory category : FoodCategory.values()) {
            map.put(category, CrockPotRegistry.register(ITEMS, "food_category_" + category.name().toLowerCase(), new Item(new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP))));
        }
    });

    private static <T extends IForgeRegistryEntry<T>, E extends T> E register(DeferredRegister<T> register, String name, E entry) {
        register.register(name, () -> entry);
        return entry;
    }
}

