/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CrockPotDoubleCropsBlock
extends CrockPotCropsBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelShapes.func_197868_b(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelShapes.func_197868_b()};

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.func_185524_e())];
    }

    public boolean isUpperBlock(BlockState state) {
        return this.func_185527_x(state) > this.func_185526_g() / 2;
    }

    public int getMaxGrowthAge(BlockState state) {
        return this.isUpperBlock(state) ? this.func_185526_g() : this.func_185526_g() / 2;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            BlockPos lowerPos;
            BlockState lowerState;
            if (!player.func_184812_l_()) {
                CrockPotDoubleCropsBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
            if ((lowerState = worldIn.func_180495_p(lowerPos = this.isUpperBlock(state) ? pos.func_177977_b() : pos)).func_177230_c() == state.func_177230_c()) {
                worldIn.func_180501_a(lowerPos, Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, lowerPos, Block.func_196246_j((BlockState)lowerState));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockPos;
        float growthChance;
        int age;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (age = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthChance = CrockPotDoubleCropsBlock.getGrowthChance(this, (IBlockReader)worldIn, blockPos = this.isUpperBlock(state) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this.getBlock() ? pos.func_177977_b() : pos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (age != this.getMaxGrowthAge(state)) {
                worldIn.func_180501_a(pos, this.func_185528_e(age + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            } else if (worldIn.func_175623_d(pos.func_177984_a())) {
                worldIn.func_180501_a(pos.func_177984_a(), this.func_185528_e(age + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int maxAge;
        int age = this.func_185527_x(state);
        if (age < (maxAge = this.func_185526_g())) {
            int maxGrowthAge = this.getMaxGrowthAge(state);
            if (age != maxGrowthAge) {
                int expectedAge = age + this.func_185529_b(worldIn);
                if (expectedAge > maxAge) {
                    expectedAge = maxAge;
                }
                if (expectedAge > maxGrowthAge) {
                    worldIn.func_180501_a(pos, this.func_185528_e(maxGrowthAge), 2);
                    if (worldIn.func_175623_d(pos.func_177984_a())) {
                        worldIn.func_180501_a(pos.func_177984_a(), this.func_185528_e(expectedAge), 2);
                    }
                } else {
                    worldIn.func_180501_a(pos, this.func_185528_e(expectedAge), 2);
                }
            } else {
                BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
                if (stateUp.func_177230_c() == this.getBlock() && this.func_185527_x(stateUp) != this.getMaxGrowthAge(stateUp)) {
                    int expectedAge = this.func_185527_x(stateUp) + this.func_185529_b(worldIn);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    worldIn.func_180501_a(pos.func_177984_a(), this.func_185528_e(expectedAge), 2);
                } else if (worldIn.func_175623_d(pos.func_177984_a())) {
                    int expectedAge = age + this.func_185529_b(worldIn);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    worldIn.func_180501_a(pos.func_177984_a(), this.func_185528_e(expectedAge), 2);
                }
            }
        }
    }

    protected static float getGrowthChance(CrockPotDoubleCropsBlock blockIn, IBlockReader worldIn, BlockPos pos) {
        if (blockIn.isUpperBlock(worldIn.func_180495_p(pos))) {
            return CropsBlock.func_180672_a((Block)blockIn, (IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
        }
        return CropsBlock.func_180672_a((Block)blockIn, (IBlockReader)worldIn, (BlockPos)pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (this.isUpperBlock(state)) {
            BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            return (worldIn.func_226659_b_(pos, 0) >= 8 || worldIn.func_226660_f_(pos)) && stateDown.func_177230_c() == this.getBlock() && this.func_185527_x(stateDown) == this.getMaxGrowthAge(stateDown);
        }
        return super.func_196260_a(state, worldIn, pos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            if (this.func_185527_x(state) != this.getMaxGrowthAge(state)) {
                return true;
            }
            BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
            return stateUp.func_177230_c() == this.getBlock() && this.func_185527_x(stateUp) != this.getMaxGrowthAge(stateUp) || stateUp.isAir(worldIn, pos.func_177984_a());
        }
        return false;
    }
}

