/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.capability;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.sihenzhang.crockpot.capability.IFoodCounter;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoodCounter
implements IFoodCounter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Multiset<Item> counter = HashMultiset.create();

    @Override
    public boolean hasEaten(Item food) {
        return this.counter.contains((Object)food);
    }

    @Override
    public void addFood(Item food) {
        this.counter.add((Object)food);
    }

    @Override
    public int getCount(Item food) {
        return this.counter.count((Object)food);
    }

    @Override
    public void setCount(Item food, int count) {
        this.counter.setCount((Object)food, count);
    }

    @Override
    public void clear() {
        this.counter.clear();
    }

    @Override
    public Map<Item, Integer> asMap() {
        return Maps.asMap((Set)this.counter.elementSet(), arg_0 -> this.counter.count(arg_0));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.asMap().forEach((food, count) -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)food);
            if (key != null) {
                CompoundNBT foodCount = new CompoundNBT();
                foodCount.func_74778_a("Food", key.toString());
                foodCount.func_74768_a("Count", count.intValue());
                list.add((Object)foodCount);
            }
        });
        tag.func_218657_a("FoodCounter", (INBT)list);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.clear();
        ListNBT foodCounter = nbt.func_150295_c("FoodCounter", 10);
        foodCounter.stream().map(CompoundNBT.class::cast).forEach(foodCount -> {
            String key = foodCount.func_74779_i("Food");
            Item food = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(foodCount.func_74779_i("Food")));
            if (food == null) {
                LOGGER.warn("Attempt to load unregistered item: \"" + key + "\", will remove this.");
                return;
            }
            if (!food.func_219971_r()) {
                LOGGER.warn("Attempting to load item that is not edible: \"" + key + "\", will not remove this in case it becomes edible again later.");
            }
            this.setCount(food, foodCount.func_74762_e("Count"));
        });
    }
}

