/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class FoodValuesTooltip {
    private static final IFormattableTextComponent DELIMITER = new StringTextComponent(", ").func_240699_a_(TextFormatting.WHITE);

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        FoodValues foodValues;
        PlayerEntity player = event.getPlayer();
        if (player != null && player.field_70170_p != null && !(foodValues = FoodValuesDefinition.getFoodValues(event.getItemStack().func_77973_b(), player.field_70170_p.func_199532_z())).isEmpty()) {
            IFormattableTextComponent tooltip = null;
            for (Pair<FoodCategory, Float> entry : foodValues.entrySet()) {
                IFormattableTextComponent foodValuesText = new TranslationTextComponent("tooltip.crockpot.food_values", new Object[]{new TranslationTextComponent("item.crockpot.food_category_" + ((FoodCategory)((Object)entry.getKey())).name().toLowerCase()), entry.getValue()}).func_240703_c_(Style.field_240709_b_.func_240718_a_(((FoodCategory)((Object)entry.getKey())).color));
                if (tooltip == null) {
                    tooltip = foodValuesText;
                    continue;
                }
                tooltip.func_230529_a_((ITextComponent)DELIMITER).func_230529_a_((ITextComponent)foodValuesText);
            }
            event.getToolTip().add(tooltip);
        }
    }
}

