/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class GnawsGiftHungerOverlay {
    private static final ResourceLocation GNAWS_GIFT_ICONS = new ResourceLocation("crockpot", "textures/gui/gnaws_gift.png");
    private static int foodIconsOffset;

    @SubscribeEvent
    public static void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)CrockPotConfig.GNAWS_GIFT_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        foodIconsOffset = ForgeIngameGui.right_height;
    }

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (!((Boolean)CrockPotConfig.GNAWS_GIFT_HUNGER_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && player.func_70644_a(CrockPotRegistry.gnawsGift)) {
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 0.01);
            mc.func_110434_K().func_110577_a(GNAWS_GIFT_ICONS);
            RenderSystem.enableBlend();
            int left = mc.func_228018_at_().func_198107_o() / 2 + 91;
            int top = mc.func_228018_at_().func_198087_p() - foodIconsOffset;
            int tickCount = mc.field_71456_v.func_73834_c();
            Random rand = new Random();
            rand.setSeed((long)tickCount * 312871L);
            FoodStats stats = player.func_71024_bL();
            int level = stats.func_75116_a();
            for (int i = 0; i < 10; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * 8 - 9;
                int y = top;
                if (stats.func_75115_e() <= 0.0f && tickCount % (level * 3 + 1) == 0) {
                    y = top + (rand.nextInt(3) - 1);
                }
                mc.field_71456_v.func_238474_b_(matrixStack, x, y, 0, 0, 9, 9);
                if (idx < level) {
                    mc.field_71456_v.func_238474_b_(matrixStack, x, y, 9, 0, 9, 9);
                    continue;
                }
                if (idx != level) continue;
                mc.field_71456_v.func_238474_b_(matrixStack, x, y, 18, 0, 9, 9);
            }
            RenderSystem.disableBlend();
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            matrixStack.func_227865_b_();
        }
    }
}

