/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.curios;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sihenzhang.crockpot.client.renderer.model.MilkmadeHatModel;
import com.sihenzhang.crockpot.integration.curios.CuriosUtils;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.util.RenderUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class MilkmadeHatCuriosCapabilityProvider
implements ICapabilityProvider {
    private static final ResourceLocation MILKMADE_HAT_TEXTURE = new ResourceLocation("crockpot", "textures/entity/milkmade_hat.png");
    private final LazyOptional<ICurio> curioOptional = LazyOptional.of(() -> new ICurio(){
        private Object model;

        public void curioTick(String identifier, int index, LivingEntity livingEntity) {
            if (livingEntity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)livingEntity;
                if (!player.field_70170_p.field_72995_K && player.func_71024_bL().func_75121_c() && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                    if (!isCreative) {
                        stack.func_222118_a(1, (LivingEntity)player, e -> CuriosApi.getCuriosHelper().onBrokenCurio(identifier, index, (LivingEntity)e));
                    }
                    player.func_71024_bL().func_75122_a(1, 0.05f);
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), isCreative ? 20 : 100);
                }
            }
        }

        public boolean canEquip(String identifier, LivingEntity livingEntity) {
            return !livingEntity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().getTags().contains(MilkmadeHatItem.TAG) && !CuriosUtils.anyMatchInEquippedCurios(livingEntity, MilkmadeHatItem.TAG);
        }

        public boolean canEquipFromUse(SlotContext slotContext) {
            return true;
        }

        public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
            return true;
        }

        public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!(this.model instanceof MilkmadeHatModel)) {
                this.model = new MilkmadeHatModel();
            }
            MilkmadeHatModel milkmadeHatModel = (MilkmadeHatModel)((Object)this.model);
            RenderUtils.copyPropertiesFromLivingEntityModelTo(livingEntity, (Object)milkmadeHatModel);
            ICurio.RenderHelper.followHeadRotations((LivingEntity)livingEntity, (ModelRenderer[])new ModelRenderer[]{milkmadeHatModel.field_78116_c});
            IVertexBuilder vertexBuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)MILKMADE_HAT_TEXTURE), (boolean)false, (boolean)stack.func_77962_s());
            milkmadeHatModel.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    });

    public MilkmadeHatCuriosCapabilityProvider(ItemStack stack, @Nullable CompoundNBT nbt) {
        this(stack, nbt, false);
    }

    public MilkmadeHatCuriosCapabilityProvider(final ItemStack stack, @Nullable CompoundNBT nbt, final boolean isCreative) {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CuriosCapability.ITEM.orEmpty(cap, this.curioOptional);
    }
}

