/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jade;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.integration.jade.ModIntegrationJade;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import snownee.jade.Renderables;

public class CrockPotProvider
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final CrockPotProvider INSTANCE = new CrockPotProvider();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        CompoundNBT serverData;
        if (config.get(ModIntegrationJade.CROCK_POT) && (serverData = accessor.getServerData()).func_74764_b("CrockPotItemHandler")) {
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.deserializeNBT(serverData.func_74775_l("CrockPotItemHandler"));
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
            ArrayList<RenderableTextComponent> inputs = new ArrayList<RenderableTextComponent>();
            for (int i = 0; i < 4; ++i) {
                ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                inputStacks.add(stackInSlot);
                inputs.add(Renderables.item((ItemStack)stackInSlot));
            }
            int progress = serverData.func_74762_e("CookingProgress");
            CompoundNBT progressTag = new CompoundNBT();
            progressTag.func_74768_a("progress", progress);
            progressTag.func_74768_a("total", progress > 0 ? 100 : 0);
            RenderableTextComponent result = Renderables.item((ItemStack)(serverData.func_74764_b("Result") ? ItemStack.func_199557_a((CompoundNBT)serverData.func_74775_l("Result")) : itemHandler.getStackInSlot(5)));
            tooltip.add((ITextComponent)Renderables.of((ITextComponent[])new ITextComponent[]{Renderables.of((ITextComponent[])inputs.toArray(new ITextComponent[0])), new RenderableTextComponent(new ResourceLocation("furnace_progress"), progressTag), result}));
            if (serverData.func_74767_n("DrawFoodValue")) {
                FoodValues mergedFoodValues = FoodValues.merge(inputStacks.stream().filter(stack -> !stack.func_190926_b()).map(stack -> FoodValuesDefinition.getFoodValues(stack.func_77973_b(), accessor.getWorld().func_199532_z())).collect(Collectors.toList()));
                ArrayList<RenderableTextComponent> foodValuesRow = new ArrayList<RenderableTextComponent>();
                int categoryCount = 0;
                for (Pair<FoodCategory, Float> entry : mergedFoodValues.entrySet()) {
                    if (categoryCount % 3 == 0 && !foodValuesRow.isEmpty()) {
                        tooltip.add((ITextComponent)Renderables.of((ITextComponent[])foodValuesRow.toArray(new ITextComponent[0])));
                        foodValuesRow.clear();
                    }
                    if (!foodValuesRow.isEmpty()) {
                        foodValuesRow.add(Renderables.spacer((int)2, (int)0));
                    }
                    foodValuesRow.add(Renderables.item((ItemStack)FoodCategory.getItemStack((FoodCategory)((Object)entry.getKey()))));
                    foodValuesRow.add(Renderables.offsetText((String)("\u00d7" + entry.getValue()), (int)0, (int)4));
                    ++categoryCount;
                }
                if (!foodValuesRow.isEmpty()) {
                    tooltip.add((ITextComponent)Renderables.of((ITextComponent[])foodValuesRow.toArray(new ITextComponent[0])));
                }
            }
        }
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, TileEntity tileEntity) {
        if (tileEntity instanceof CrockPotTileEntity) {
            CrockPotTileEntity crockPotTileEntity = (CrockPotTileEntity)tileEntity;
            tag.func_82580_o("jadeHandler");
            tag.func_218657_a("CrockPotItemHandler", (INBT)crockPotTileEntity.getItemHandler().serializeNBT());
            tag.func_74757_a("DrawFoodValue", player.func_225608_bj_());
            if (crockPotTileEntity.isCooking()) {
                tag.func_218657_a("Result", (INBT)crockPotTileEntity.getResult().serializeNBT());
                tag.func_74768_a("CookingProgress", (int)(crockPotTileEntity.getCookingProgress() * 100.0f));
            }
        }
    }
}

