/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.AbstractDrawableRequirement;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CrockPotCookingRecipeCategory
implements IRecipeCategory<CrockPotCookingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "crock_pot_cooking");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable priority;
    private final IDrawable time;
    private final LoadingCache<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>> cachedDrawables;
    public static final List<ItemStack> POTS = ImmutableList.of((Object)CrockPotRegistry.crockPotBasicBlockItem.func_190903_i(), (Object)CrockPotRegistry.crockPotAdvancedBlockItem.func_190903_i(), (Object)CrockPotRegistry.crockPotUltimateBlockItem.func_190903_i());

    public CrockPotCookingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 0, 0, 176, 133);
        this.icon = guiHelper.createDrawableIngredient((Object)CrockPotRegistry.crockPotBasicBlockItem.func_190903_i());
        this.priority = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 176, 0, 16, 16);
        this.time = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 176, 16, 16, 16);
        this.cachedDrawables = CacheBuilder.newBuilder().maximumSize(32L).build((CacheLoader)new CacheLoader<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>>(){

            public List<AbstractDrawableRequirement<? extends IRequirement>> load(CrockPotCookingRecipe key) {
                return AbstractDrawableRequirement.getDrawables(key.getRequirements());
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrockPotCookingRecipe> getRecipeClass() {
        return CrockPotCookingRecipe.class;
    }

    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return new TranslationTextComponent("integration.crockpot.jei.crock_pot_cooking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CrockPotCookingRecipe recipe, IIngredients ingredients) {
        ArrayList inputLists = new ArrayList();
        ArrayList<ItemStack> pots = new ArrayList<ItemStack>();
        for (int i = 0; i < POTS.size(); ++i) {
            if (i < recipe.getPotLevel()) continue;
            pots.add(POTS.get(i));
        }
        inputLists.add(pots);
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        drawables.forEach(drawable -> inputLists.addAll(drawable.getInputLists()));
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrockPotCookingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int slot = 0;
        guiItemStacks.init(slot, true, 61, 103);
        guiItemStacks.set(slot++, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.init(slot, false, 103, 109);
        guiItemStacks.set(slot++, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            List<AbstractDrawableRequirement.GuiItemStacksInfo> guiItemStacksInfos = drawable.getGuiItemStacksInfos(xOffset, yOffset);
            for (AbstractDrawableRequirement.GuiItemStacksInfo guiItemStacksInfo : guiItemStacksInfos) {
                guiItemStacks.init(slot, true, guiItemStacksInfo.x - 1, guiItemStacksInfo.y - 1);
                guiItemStacks.set(slot++, guiItemStacksInfo.stacks);
            }
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
    }

    public void draw(CrockPotCookingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int cookingTime = recipe.getCookingTime();
        if (cookingTime > 0) {
            int cookingTimeSeconds = cookingTime / 20;
            this.time.draw(matrixStack, 0, 117);
            font.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("integration.crockpot.jei.crock_pot_cooking.cooking_time.second", new Object[]{cookingTimeSeconds}), 17.0f, 121.0f, -8355712);
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = font.func_78256_a(priorityString);
        this.priority.draw(matrixStack, 159 - priorityWidth, 117);
        font.func_238421_b_(matrixStack, priorityString, (float)(175 - priorityWidth), 121.0f, -8355712);
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            drawable.draw(matrixStack, xOffset, yOffset);
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
    }

    public List<ITextComponent> getTooltipStrings(CrockPotCookingRecipe recipe, double mouseX, double mouseY) {
        if (mouseX >= 0.0 && mouseX <= 16.0 && mouseY >= 117.0 && mouseY <= 133.0) {
            return Collections.singletonList(new TranslationTextComponent("integration.crockpot.jei.crock_pot_cooking.cooking_time"));
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(priorityString);
        if (mouseX >= 159.0 - (double)priorityWidth && mouseX <= 175.0 - (double)priorityWidth && mouseY >= 117.0 && mouseY <= 133.0) {
            return Collections.singletonList(new TranslationTextComponent("integration.crockpot.jei.crock_pot_cooking.priority"));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

