/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.sihenzhang.crockpot.integration.jei.gui.DrawableFramed;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ExplosionCraftingRecipeCategory
implements IRecipeCategory<ExplosionCraftingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "explosion_crafting");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedExplosion;
    private final IDrawable onlyBlock;

    public ExplosionCraftingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 0, 0, 127, 46);
        this.icon = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/icons.png"), 0, 0, 16, 16);
        this.animatedExplosion = new DrawableFramed(guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 127, 0, 27, 240), 20, 10, IDrawableAnimated.StartDirection.TOP);
        this.onlyBlock = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 154, 0, 16, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ExplosionCraftingRecipe> getRecipeClass() {
        return ExplosionCraftingRecipe.class;
    }

    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return new TranslationTextComponent("integration.crockpot.jei.explosion_crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 18, 9);
        guiItemStacks.init(1, false, 87, 9);
        guiItemStacks.set(ingredients);
    }

    public void draw(ExplosionCraftingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedExplosion.draw(matrixStack, 46, 6);
        if (recipe.isOnlyBlock()) {
            this.onlyBlock.draw(matrixStack, 21, 29);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String chance = StringUtils.format(1.0f - recipe.getLossRate(), "0.##%");
        int width = fontRenderer.func_78256_a(chance);
        fontRenderer.func_238421_b_(matrixStack, chance, 97.0f - (float)width / 2.0f, 36.0f, -8355712);
    }

    public List<ITextComponent> getTooltipStrings(ExplosionCraftingRecipe recipe, double mouseX, double mouseY) {
        if (recipe.isOnlyBlock() && mouseX >= 21.0 && mouseX <= 37.0 && mouseY >= 29.0 && mouseY <= 45.0) {
            return Collections.singletonList(new TranslationTextComponent("integration.crockpot.jei.explosion_crafting.only_block"));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

