/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public final class JeiUtils {
    public static void reloadJei() {
        ClientPlayerEntity player;
        if (EffectiveSide.get().isClient() && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new RecipesUpdatedEvent(player.field_71174_a.func_199526_e()));
            MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent.CustomTagTypes(player.field_71174_a.func_199724_l()));
        }
    }

    public static List<List<ItemStack>> getPagedIngredients(IRecipeLayout recipeLayout, IIngredients ingredients, int size, boolean input) {
        List<Object> ingredientStacks = input ? ingredients.getInputs(VanillaTypes.ITEM) : ingredients.getOutputs(VanillaTypes.ITEM);
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null && (input && focus.getMode() == IFocus.Mode.INPUT || !input && focus.getMode() == IFocus.Mode.OUTPUT)) {
            ingredientStacks = ingredientStacks.stream().filter(list -> ItemStack.func_179545_c((ItemStack)((ItemStack)list.get(0)), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
        }
        if (ingredientStacks.size() > size) {
            ArrayList pagedIngredients = new ArrayList();
            for (int i = 0; i < size; ++i) {
                pagedIngredients.add(new ArrayList((Collection)ingredientStacks.get(i)));
            }
            int pages = (int)Math.ceil((double)ingredientStacks.size() / (double)size);
            for (int i = 1; i < pages; ++i) {
                for (int j = 0; j < size; ++j) {
                    ((List)pagedIngredients.get(j)).add(i * size + j < ingredientStacks.size() ? (ItemStack)((List)ingredientStacks.get(i * size + j)).get(0) : null);
                }
            }
            ingredientStacks = pagedIngredients;
        }
        return ingredientStacks;
    }
}

