/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.integration.jei.CrockPotCookingRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.ExplosionCraftingRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.FoodValuesCategory;
import com.sihenzhang.crockpot.integration.jei.PiglinBarteringRecipeCategory;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class ModIntegrationJei
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("crockpot", "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CrockPotCookingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FoodValuesCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExplosionCraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PiglinBarteringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registration.addRecipes((Collection)recipeManager.func_241447_a_(CrockPotRecipeTypes.CROCK_POT_COOKING_RECIPE_TYPE).stream().filter(r -> r.getResult().func_77973_b() != CrockPotRegistry.avaj).collect(Collectors.toList()), CrockPotCookingRecipeCategory.UID);
        registration.addRecipes(FoodValuesDefinition.getFoodCategoryMatchedItemsList(recipeManager), FoodValuesCategory.UID);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(CrockPotRecipeTypes.EXPLOSION_CRAFT_RECIPE_TYPE), ExplosionCraftingRecipeCategory.UID);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE), PiglinBarteringRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        CrockPotCookingRecipeCategory.POTS.forEach(pot -> registration.addRecipeCatalyst(pot, new ResourceLocation[]{CrockPotCookingRecipeCategory.UID}));
    }
}

