/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.sihenzhang.crockpot.integration.jei.JeiUtils;
import com.sihenzhang.crockpot.recipe.WeightedItem;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.util.NbtUtils;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PiglinBarteringRecipeCategory
implements IRecipeCategory<PiglinBarteringRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "piglin_bartering");
    private final IDrawable background;
    private final IDrawable icon;
    private final Cache<PiglinBarteringRecipe, IGuiIngredient<ItemStack>> cachedInputGuiIngredients;

    public PiglinBarteringRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/piglin_bartering.png"), 0, 0, 176, 112);
        this.icon = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/icons.png"), 32, 0, 16, 16);
        this.cachedInputGuiIngredients = CacheBuilder.newBuilder().maximumSize(16L).build();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PiglinBarteringRecipe> getRecipeClass() {
        return PiglinBarteringRecipe.class;
    }

    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return new TranslationTextComponent("integration.crockpot.jei.piglin_bartering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PiglinBarteringRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getWeightedResults().stream().map(e -> NbtUtils.setLoreString(e.item.func_190903_i(), WeightedItem.getCountAndChance(e, recipe.getWeightedResults()))).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PiglinBarteringRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int slot = 0;
        guiItemStacks.init(slot++, true, 31, 2);
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 5; ++col) {
                guiItemStacks.init(slot++, false, 84 + col * 18, 2 + row * 18);
            }
        }
        List<List<ItemStack>> pagedIngredientsOutputs = JeiUtils.getPagedIngredients(recipeLayout, ingredients, 30, false);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        for (int i = 0; i < pagedIngredientsOutputs.size(); ++i) {
            guiItemStacks.set(i + 1, pagedIngredientsOutputs.get(i));
        }
        this.cachedInputGuiIngredients.put((Object)recipe, guiItemStacks.getGuiIngredients().get(0));
    }

    public void draw(PiglinBarteringRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        boolean emptyInOffhand;
        ItemStack inputStack;
        PiglinEntity piglinEntity = (PiglinEntity)EntityType.field_233591_ai_.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        piglinEntity.func_242340_t(true);
        piglinEntity.func_184201_a(EquipmentSlotType.MAINHAND, Items.field_151010_B.func_190903_i());
        IGuiIngredient inputGuiIngredient = (IGuiIngredient)this.cachedInputGuiIngredients.getIfPresent((Object)recipe);
        if (inputGuiIngredient != null && (inputStack = (ItemStack)inputGuiIngredient.getDisplayedIngredient()) != null) {
            piglinEntity.func_184201_a(EquipmentSlotType.OFFHAND, inputStack);
            piglinEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_234080_N_, (Object)true);
        }
        if (emptyInOffhand = piglinEntity.func_184592_cb().func_190926_b()) {
            double yaw = 30.0 - mouseX;
            double pitch = 45.0 - mouseY;
            piglinEntity.field_70761_aq = (float)Math.atan(yaw / 40.0) * 20.0f;
            piglinEntity.field_70177_z = (float)Math.atan(yaw / 40.0) * 40.0f;
            piglinEntity.field_70125_A = -((float)Math.atan(pitch / 40.0)) * 20.0f;
            piglinEntity.field_70759_as = piglinEntity.field_70177_z;
            piglinEntity.field_70758_at = piglinEntity.field_70177_z;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(emptyInOffhand ? 29.0 : 37.0, 103.0, 50.0);
        matrixStack.func_227862_a_(-32.0f, 32.0f, 32.0f);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (!emptyInOffhand) {
            matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(45.0f));
        }
        EntityRendererManager entityRendererManager = Minecraft.func_71410_x().func_175598_ae();
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityRendererManager.func_178633_a(false);
        entityRendererManager.func_229084_a_((Entity)piglinEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
        entityRendererManager.func_178633_a(true);
        renderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }
}

