/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.integration.kubejs.AbstractCrockPotRecipeJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FoodValuesDefinitionJS
extends AbstractCrockPotRecipeJS {
    public Set<ResourceLocation> names = new HashSet<ResourceLocation>();
    public FoodValues foodValues;
    public boolean isTag;

    public void create(ListJS args) {
        this.foodValues = this.parseFoodValues(args.get(0));
        this.foodValues.entrySet().forEach(entry -> this.outputItems.add(this.parseResultItem(FoodCategory.getItemStack((FoodCategory)((Object)((Object)entry.getKey()))))));
        this.isTag = (Boolean)args.get(1);
        for (int i = 2; i < args.size(); ++i) {
            this.define(args.get(i).toString());
        }
    }

    public void deserialize() {
        this.foodValues = this.parseFoodValues(JSONUtils.func_152754_s((JsonObject)this.json, (String)"values"));
        this.foodValues.entrySet().forEach(entry -> this.outputItems.add(this.parseResultItem(FoodCategory.getItemStack((FoodCategory)((Object)((Object)entry.getKey()))))));
        this.isTag = this.json.has("tags");
        JSONUtils.func_151214_t((JsonObject)this.json, (String)(this.isTag ? "tags" : "items")).forEach(o -> this.define(o.getAsString()));
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("values", this.foodValues.toJson());
        }
        if (this.serializeInputs) {
            JsonArray arr = new JsonArray();
            this.names.forEach(name -> arr.add(name.toString()));
            this.json.add(this.isTag ? "tags" : "items", (JsonElement)arr);
        }
    }

    public FoodValuesDefinitionJS define(String name) {
        String nameWithoutHashSymbol = name.replace("#", "");
        ResourceLocation rl = new ResourceLocation(nameWithoutHashSymbol);
        this.names.add(rl);
        if (this.isTag) {
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(rl);
            if (tag != null) {
                this.inputItems.add(this.parseIngredientItem(Ingredient.func_199805_a((ITag)tag)));
            }
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (item != null && item != Items.field_190931_a) {
                this.inputItems.add(this.parseIngredientItem(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item})));
            }
        }
        return this;
    }
}

