/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.io.IOUtils;
import vazkii.patchouli.api.PatchouliAPI;

public class PacketCrockPotConfigFlag {
    private final String data;

    public PacketCrockPotConfigFlag(String data) {
        this.data = data;
    }

    public static void serialize(PacketCrockPotConfigFlag pack, PacketBuffer buf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            gos.write(pack.data.getBytes(StandardCharsets.UTF_8));
            gos.close();
            buf.func_179250_a(bos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to compress", e);
        }
    }

    public static PacketCrockPotConfigFlag deserialize(PacketBuffer buf) {
        try {
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(buf.func_179251_a()));
            String data = IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.UTF_8);
            gis.close();
            return new PacketCrockPotConfigFlag(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress", e);
        }
    }

    public static void handle(PacketCrockPotConfigFlag pack, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (ModList.get().isLoaded("patchouli")) {
                JsonObject flags = JSONUtils.func_212745_a((String)pack.data);
                flags.entrySet().forEach(entry -> PatchouliAPI.get().setConfigFlag((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean()));
                PatchouliAPI.get().reloadBookContents();
            }
        });
        context.setPacketHandled(true);
    }
}

