/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.integration.patchouli.PatchouliUtils;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.util.StringUtils;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorExplosionCrafting
implements IComponentProcessor {
    private ExplosionCraftingRecipe recipe;

    public void setup(IVariableProvider variables) {
        this.recipe = (ExplosionCraftingRecipe)PatchouliUtils.getRecipe(variables.get("recipe").asString());
    }

    public IVariable process(String key) {
        switch (key) {
            case "input": {
                return PatchouliUtils.ingredientVariable(this.recipe.getIngredient());
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getResult());
            }
            case "explosionTooltip": {
                return IVariable.from((Object)new TranslationTextComponent("integration.crockpot.book.explosion_crafting.explosion"));
            }
            case "isOnlyBlock": {
                return IVariable.wrap((Boolean)this.recipe.isOnlyBlock());
            }
            case "onlyBlockTooltip": {
                return IVariable.from((Object)new TranslationTextComponent("integration.crockpot.book.explosion_crafting.only_block"));
            }
            case "rate": {
                return IVariable.wrap((String)StringUtils.format(1.0f - this.recipe.getLossRate(), "0.##%"));
            }
            case "title": {
                return IVariable.from((Object)this.recipe.getResult().func_200301_q());
            }
        }
        return null;
    }
}

