/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.integration.patchouli.PatchouliUtils;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.EnumUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorFoodValues
implements IComponentProcessor {
    private String categoryName;
    private Set<Item> items;
    private List<IVariable> pagedItems;

    public void setup(IVariableProvider variables) {
        this.categoryName = variables.get("category").asString();
        FoodCategory category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)this.categoryName.toUpperCase());
        this.items = FoodValuesDefinition.getMatchedItems(category, Minecraft.func_71410_x().field_71441_e.func_199532_z());
        this.pagedItems = PatchouliUtils.pagedItemVariables(this.items.stream().map(Item::func_190903_i).collect(Collectors.toList()), 42);
    }

    public IVariable process(String key) {
        if (key.startsWith("item")) {
            int index = Integer.parseInt(key.substring(4)) - 1;
            if (index < 0 || index >= Math.min(this.items.size(), 42)) {
                return IVariable.from((Object)ItemStack.field_190927_a);
            }
            return this.pagedItems.get(index);
        }
        if ("title".equals(key)) {
            return IVariable.wrap((String)I18n.func_135052_a((String)("item.crockpot.food_category_" + this.categoryName.toLowerCase()), (Object[])new Object[0]));
        }
        return null;
    }
}

