/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.integration.patchouli.PatchouliUtils;
import com.sihenzhang.crockpot.recipe.WeightedItem;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.util.NbtUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorPiglinBartering
implements IComponentProcessor {
    private PiglinBarteringRecipe recipe;
    private List<IVariable> pagedResults;

    public void setup(IVariableProvider variables) {
        this.recipe = (PiglinBarteringRecipe)PatchouliUtils.getRecipe(variables.get("recipe").asString());
        this.pagedResults = PatchouliUtils.pagedItemVariables(this.recipe.getWeightedResults().stream().map(e -> NbtUtils.setLoreString(e.item.func_190903_i(), WeightedItem.getCountAndChance(e, this.recipe.getWeightedResults()))).collect(Collectors.toList()), 30);
    }

    public IVariable process(String key) {
        if ("input".equals(key)) {
            return PatchouliUtils.ingredientVariable(this.recipe.getIngredient());
        }
        if (key.startsWith("output")) {
            int index = Integer.parseInt(key.substring(6)) - 1;
            if (index < 0 || index >= Math.min(this.recipe.getWeightedResults().size(), 30)) {
                return IVariable.from((Object)ItemStack.field_190927_a);
            }
            return this.pagedResults.get(index);
        }
        if ("piglinBarteringTooltip".equals(key)) {
            return IVariable.from((Object)new TranslationTextComponent("integration.crockpot.book.piglin_bartering.piglin_bartering"));
        }
        return null;
    }
}

