/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.integration.curios.CuriosUtils;
import com.sihenzhang.crockpot.integration.curios.MilkmadeHatCuriosCapabilityProvider;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class MilkmadeHatItem
extends Item {
    public static ResourceLocation TAG = new ResourceLocation("crockpot", "milkmade_hat");

    public MilkmadeHatItem() {
        this(new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP).func_200918_c(180).setNoRepair());
    }

    protected MilkmadeHatItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.HEAD;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        if (ModList.get().isLoaded("curios") && entity instanceof LivingEntity && CuriosUtils.anyMatchInEquippedCurios((LivingEntity)entity, TAG)) {
            return false;
        }
        return super.canEquip(stack, armorType, entity);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (ModList.get().isLoaded("curios") && CuriosUtils.anyMatchInEquippedCurios((LivingEntity)playerIn, TAG)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        EquipmentSlotType equipmentSlotForItem = MobEntity.func_184640_d((ItemStack)stack);
        ItemStack stackBySlot = playerIn.func_184582_a(equipmentSlotForItem);
        if (stackBySlot.func_190926_b()) {
            playerIn.func_184201_a(equipmentSlotForItem, stack.func_77946_l());
            stack.func_190920_e(0);
            return ActionResult.func_233538_a_((Object)stack, (boolean)worldIn.field_72995_K);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K && player.func_71024_bL().func_75121_c() && !player.func_184811_cZ().func_185141_a((Item)this)) {
            stack.func_222118_a(1, (LivingEntity)player, e -> e.func_213361_c(EquipmentSlotType.HEAD));
            player.func_71024_bL().func_75122_a(1, 0.05f);
            player.func_184811_cZ().func_185145_a((Item)this, 100);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (ModList.get().isLoaded("curios")) {
            return new MilkmadeHatCuriosCapabilityProvider(stack, nbt);
        }
        return super.initCapabilities(stack, nbt);
    }
}

