/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.item.food.CrockPotFood;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Candy
extends CrockPotFood {
    private static final Supplier<IFormattableTextComponent> SPACE = () -> new StringTextComponent("  ");
    private static final IFormattableTextComponent DELIMITER = new StringTextComponent(", ").func_240699_a_(TextFormatting.GRAY);

    public Candy() {
        super(CrockPotFood.builder().nutrition(3).saturationMod(0.2f).alwaysEat().duration(FoodUseDuration.FAST).effectTooltip("candy", TextFormatting.DARK_GREEN).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.no_effect").func_240699_a_(TextFormatting.GRAY))).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.remove", new Object[]{new TranslationTextComponent(Effects.field_76421_d.func_76393_a())}).func_240699_a_(TextFormatting.GOLD))).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("potion.withAmplifier", new Object[]{new TranslationTextComponent(Effects.field_76443_y.func_76393_a()), new TranslationTextComponent("potion.potency.1")}).func_240699_a_(TextFormatting.BLUE)).func_230529_a_((ITextComponent)DELIMITER).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.remove", new Object[]{new TranslationTextComponent(Effects.field_76438_s.func_76393_a())}).func_240699_a_(TextFormatting.GOLD))).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("potion.withDuration", new Object[]{new TranslationTextComponent(Effects.field_76422_e.func_76393_a()), StringUtils.formatTickDuration(400)}).func_240699_a_(TextFormatting.BLUE)).func_230529_a_((ITextComponent)DELIMITER).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.remove", new Object[]{new TranslationTextComponent(Effects.field_76419_f.func_76393_a())}).func_240699_a_(TextFormatting.GOLD))).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("potion.withDuration", new Object[]{new TranslationTextComponent(Effects.field_76437_t.func_76393_a()), StringUtils.formatTickDuration(200)}).func_240699_a_(TextFormatting.RED)).func_230529_a_((ITextComponent)DELIMITER).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.damage.single", new Object[]{1}).func_240699_a_(TextFormatting.RED))).effectTooltip((ITextComponent)SPACE.get().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.damage.multiple", new Object[]{5}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.OBFUSCATED}))));
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K) {
            float chance = worldIn.field_73012_v.nextFloat();
            if (chance < 0.25f) {
                entityLiving.func_195063_d(Effects.field_76421_d);
            } else if (chance < 0.45f) {
                entityLiving.func_195063_d(Effects.field_76438_s);
                entityLiving.func_195064_c(new EffectInstance(Effects.field_76443_y, 1, 1));
            } else if (chance < 0.55f) {
                entityLiving.func_195063_d(Effects.field_76419_f);
                entityLiving.func_195064_c(new EffectInstance(Effects.field_76422_e, 400));
            } else if (chance < 0.6f) {
                entityLiving.func_195064_c(new EffectInstance(Effects.field_76437_t, 200));
                entityLiving.func_70097_a(CrockPotDamageSource.CANDY, 2.0f);
            } else if (chance < 0.605f) {
                entityLiving.func_70097_a(CrockPotDamageSource.CANDY, 10.0f);
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.candy.real").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.candy").func_240699_a_(TextFormatting.DARK_AQUA));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

