/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.google.common.collect.ImmutableList;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.capability.FoodCounterCapabilityHandler;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.util.MathUtils;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrockPotFood
extends Item {
    private final int duration;
    private final boolean isDrink;
    private final int cooldown;
    private final float heal;
    private final Pair<DamageSource, Float> damage;
    private final List<Effect> removedEffects;
    private final List<Supplier<ITextComponent>> tooltips;
    private final boolean hideEffects;
    private final List<Supplier<ITextComponent>> effectTooltips;

    protected CrockPotFood(CrockPotFoodBuilder builder) {
        super(builder.properties.func_221540_a(builder.foodBuilder.func_221453_d()));
        this.duration = builder.duration;
        this.isDrink = builder.isDrink;
        this.cooldown = builder.cooldown;
        this.heal = builder.heal;
        this.damage = builder.damage;
        this.removedEffects = builder.removedEffects;
        this.tooltips = builder.tooltips;
        this.hideEffects = builder.hideEffects;
        this.effectTooltips = builder.effectTooltips;
    }

    public static CrockPotFoodBuilder builder() {
        return new CrockPotFoodBuilder();
    }

    public List<Pair<EffectInstance, Float>> getEffects() {
        Food foodProperties = this.func_219967_s();
        return foodProperties == null ? ImmutableList.of() : (List)foodProperties.func_221464_f().stream().map(p -> Pair.of((Object)p.getFirst(), (Object)p.getSecond())).collect(ImmutableList.toImmutableList());
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K) {
            if (this.damage != null && ((Float)this.damage.getValue()).floatValue() > 0.0f) {
                entityLiving.func_70097_a((DamageSource)this.damage.getKey(), ((Float)this.damage.getValue()).floatValue());
            }
            if (this.heal > 0.0f) {
                entityLiving.func_70691_i(this.heal);
            }
            this.removedEffects.forEach(arg_0 -> ((LivingEntity)entityLiving).func_195063_d(arg_0));
            if (this.cooldown > 0 && entityLiving instanceof PlayerEntity) {
                ((PlayerEntity)entityLiving).func_184811_cZ().func_185145_a((Item)this, this.cooldown);
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int func_77626_a(ItemStack stack) {
        return this.duration;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.isDrink) {
            return UseAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public SoundEvent func_225519_S__() {
        if (this.isDrink) {
            return SoundEvents.field_187664_bz;
        }
        return super.func_225519_S__();
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltipComponents, ITooltipFlag isAdvanced) {
        if (!this.tooltips.isEmpty()) {
            this.tooltips.forEach(tip -> tooltipComponents.add((ITextComponent)tip.get()));
        }
        if (level != null && Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().field_71439_g.getCapability(FoodCounterCapabilityHandler.FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> {
                if (!((Boolean)CrockPotConfig.SHOW_FOOD_EFFECTS_TOOLTIP.get()).booleanValue() || this.hideEffects) {
                    return;
                }
                if (!foodCounter.hasEaten(this)) {
                    tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.not_eat").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                } else {
                    float hearts;
                    if (this.getEffects().isEmpty() && this.effectTooltips.isEmpty() && this.removedEffects.isEmpty() && this.heal <= 0.0f && (this.damage == null || ((Float)this.damage.getValue()).floatValue() <= 0.0f)) {
                        tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.no_effect").func_240699_a_(TextFormatting.GRAY));
                        return;
                    }
                    this.getEffects().forEach(p -> {
                        float probability;
                        EffectInstance effect = (EffectInstance)p.getKey();
                        TranslationTextComponent tooltip = new TranslationTextComponent(effect.func_76453_d());
                        if (effect.func_76458_c() > 0) {
                            tooltip = new TranslationTextComponent("potion.withAmplifier", new Object[]{tooltip, new TranslationTextComponent("potion.potency." + effect.func_76458_c())});
                        }
                        if (effect.func_76459_b() > 20) {
                            tooltip = new TranslationTextComponent("potion.withDuration", new Object[]{tooltip, EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f)});
                        }
                        if ((probability = ((Float)p.getValue()).floatValue()) < 1.0f) {
                            tooltip = new TranslationTextComponent("tooltip.crockpot.effect.with_probability", new Object[]{StringUtils.format(probability, "0.##%"), tooltip});
                        }
                        tooltipComponents.add((ITextComponent)tooltip.func_240699_a_(effect.func_188419_a().func_220303_e().func_220306_a()));
                    });
                    if (!this.effectTooltips.isEmpty() || !this.removedEffects.isEmpty() || this.heal > 0.0f || this.damage != null && ((Float)this.damage.getValue()).floatValue() > 0.0f) {
                        tooltipComponents.add(StringTextComponent.field_240750_d_);
                        tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.when_" + (this.isDrink ? "drunk" : "eaten")).func_240699_a_(TextFormatting.DARK_PURPLE));
                    }
                    this.effectTooltips.forEach(tip -> tooltipComponents.add((ITextComponent)tip.get()));
                    this.removedEffects.forEach(e -> tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.remove", new Object[]{new TranslationTextComponent(e.func_76393_a())}).func_240699_a_(TextFormatting.GOLD)));
                    if (this.heal > 0.0f) {
                        hearts = this.heal / 2.0f;
                        tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.heal." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), new Object[]{StringUtils.format(hearts, "0.#")}).func_240699_a_(TextFormatting.BLUE));
                    }
                    if (this.damage != null && ((Float)this.damage.getValue()).floatValue() > 0.0f) {
                        hearts = ((Float)this.damage.getValue()).floatValue() / 2.0f;
                        tooltipComponents.add((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect.damage." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), new Object[]{StringUtils.format(hearts, "0.#")}).func_240699_a_(TextFormatting.RED));
                    }
                }
            });
        }
        super.func_77624_a(stack, level, tooltipComponents, isAdvanced);
    }

    public static class CrockPotFoodBuilder {
        private Item.Properties properties = new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP);
        private int maxStackSize = 64;
        private Rarity rarity = Rarity.COMMON;
        private Food.Builder foodBuilder = new Food.Builder();
        private int duration;
        private boolean isDrink;
        private int cooldown;
        private float heal;
        private Pair<DamageSource, Float> damage;
        private final List<Effect> removedEffects;
        private final List<Supplier<ITextComponent>> tooltips;
        private boolean hideEffects;
        private final List<Supplier<ITextComponent>> effectTooltips;

        public CrockPotFoodBuilder() {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<Effect>();
            this.tooltips = new ArrayList<Supplier<ITextComponent>>();
            this.effectTooltips = new ArrayList<Supplier<ITextComponent>>();
        }

        public CrockPotFoodBuilder nutrition(int nutrition) {
            this.foodBuilder = this.foodBuilder.func_221456_a(nutrition);
            return this;
        }

        public CrockPotFoodBuilder saturationMod(float saturationModifier) {
            this.foodBuilder = this.foodBuilder.func_221454_a(saturationModifier);
            return this;
        }

        public CrockPotFoodBuilder meat() {
            this.foodBuilder = this.foodBuilder.func_221451_a();
            return this;
        }

        public CrockPotFoodBuilder alwaysEat() {
            this.foodBuilder = this.foodBuilder.func_221455_b();
            return this;
        }

        public CrockPotFoodBuilder duration(FoodUseDuration durationIn) {
            this.duration = durationIn.val;
            return this;
        }

        public CrockPotFoodBuilder effect(Supplier<EffectInstance> effect, float probability) {
            this.foodBuilder = this.foodBuilder.effect(effect, probability);
            return this;
        }

        public CrockPotFoodBuilder effect(Supplier<EffectInstance> effect) {
            this.foodBuilder = this.foodBuilder.effect(effect, 1.0f);
            return this;
        }

        public CrockPotFoodBuilder effect(Effect effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new EffectInstance(effect, duration, amplifier), probability);
        }

        public CrockPotFoodBuilder effect(Effect effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public CrockPotFoodBuilder effect(Effect effect, int duration, float probability) {
            return this.effect(() -> new EffectInstance(effect, duration), probability);
        }

        public CrockPotFoodBuilder effect(Effect effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public CrockPotFoodBuilder drink() {
            this.isDrink = true;
            return this;
        }

        public CrockPotFoodBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public CrockPotFoodBuilder heal(float heal) {
            this.heal = heal;
            return this;
        }

        public CrockPotFoodBuilder damage(DamageSource damageSource, float damageAmount) {
            this.damage = Pair.of((Object)damageSource, (Object)Float.valueOf(damageAmount));
            return this;
        }

        public CrockPotFoodBuilder removeEffect(Effect effect) {
            this.removedEffects.add(effect);
            return this;
        }

        public CrockPotFoodBuilder tooltip(String key) {
            this.tooltips.add(() -> new TranslationTextComponent("tooltip.crockpot." + key));
            return this;
        }

        public CrockPotFoodBuilder tooltip(String key, TextFormatting ... formats) {
            this.tooltips.add(() -> new TranslationTextComponent("tooltip.crockpot." + key).func_240701_a_(formats));
            return this;
        }

        public CrockPotFoodBuilder hideEffects() {
            this.hideEffects = true;
            return this;
        }

        public CrockPotFoodBuilder effectTooltip(Supplier<ITextComponent> tooltip) {
            this.effectTooltips.add(tooltip);
            return this;
        }

        public CrockPotFoodBuilder effectTooltip(ITextComponent tooltip) {
            return this.effectTooltip(() -> tooltip);
        }

        public CrockPotFoodBuilder effectTooltip(String key, TextFormatting ... formats) {
            return this.effectTooltip((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect." + key).func_240701_a_(formats));
        }

        public CrockPotFoodBuilder effectTooltip(String key) {
            return this.effectTooltip((ITextComponent)new TranslationTextComponent("tooltip.crockpot.effect." + key));
        }

        public CrockPotFoodBuilder hide() {
            this.properties = new Item.Properties();
            if (this.maxStackSize != 64) {
                this.properties = this.properties.func_200917_a(this.maxStackSize);
            }
            if (this.rarity != Rarity.COMMON) {
                this.properties = this.properties.func_208103_a(this.rarity);
            }
            return this;
        }

        public CrockPotFoodBuilder stacksTo(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            this.properties = this.properties.func_200917_a(this.maxStackSize);
            return this;
        }

        public CrockPotFoodBuilder rarity(Rarity rarity) {
            this.rarity = rarity;
            this.properties = this.properties.func_208103_a(this.rarity);
            return this;
        }

        public CrockPotFood build() {
            return new CrockPotFood(this);
        }
    }
}

