/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.mixin;

import com.sihenzhang.crockpot.base.CrockPotCriteriaTriggers;
import com.sihenzhang.crockpot.mixin.IPiglinEntityMixin;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PiglinTasks.class})
public abstract class PiglinTasksMixin {
    @Shadow
    private static void func_241427_c_(PiglinEntity p_241427_0_, ItemStack p_241427_1_) {
    }

    @Shadow
    private static void func_234475_a_(PiglinEntity p_234475_0_, List<ItemStack> p_234475_1_) {
    }

    @Shadow
    protected static boolean func_234480_a_(Item p_234480_0_) {
        return true;
    }

    @Shadow
    private static void func_234501_d_(LivingEntity p_234501_0_) {
    }

    @Shadow
    private static boolean func_234451_A_(PiglinEntity p_234451_0_) {
        return true;
    }

    @Shadow
    private static boolean func_234499_c_(Item p_234499_0_) {
        return true;
    }

    @Shadow
    private static boolean func_234453_C_(PiglinEntity p_234453_0_) {
        return true;
    }

    @Shadow
    private static boolean func_234455_E_(PiglinEntity p_234455_0_) {
        return true;
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")})
    private static void pickUpItemHandler(PiglinEntity piglinEntity, ItemEntity itemEntity, CallbackInfo ci) {
        PlayerEntity player;
        PlayerEntity playerEntity = player = itemEntity.func_200214_m() != null ? piglinEntity.field_70170_p.func_217371_b(itemEntity.func_200214_m()) : null;
        if (player != null) {
            piglinEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220952_m, (Object)player);
        }
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/entity/item/ItemEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;putInInventory(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/item/ItemStack;)V", ordinal=0)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void pickUpItemHandler(PiglinEntity piglinEntity, ItemEntity itemEntity, CallbackInfo ci, ItemStack pickedUpStack, Item pickedUpItem) {
        if (!PiglinTasksMixin.func_234499_c_(pickedUpItem) && pickedUpItem != Items.field_151074_bl && !pickedUpItem.func_206844_a((ITag)ItemTags.field_232902_M_) && PiglinBarteringRecipe.getRecipeFor(pickedUpStack, piglinEntity.field_70170_p.func_199532_z()) != null) {
            piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
            PiglinTasksMixin.func_241427_c_(piglinEntity, pickedUpStack);
            PiglinTasksMixin.func_234501_d_((LivingEntity)piglinEntity);
            ci.cancel();
        }
    }

    @Inject(method={"stopHoldingOffHandItem(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;putInInventory(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/item/ItemStack;)V", ordinal=0)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void stopHoldingOffHandItemHandler(PiglinEntity piglinEntity, boolean isNotHurt, CallbackInfo ci, ItemStack offhandStack) {
        PiglinBarteringRecipe recipe;
        if (isNotHurt && !offhandStack.func_77973_b().func_206844_a((ITag)ItemTags.field_232902_M_) && !PiglinTasksMixin.func_234499_c_(offhandStack.func_77973_b()) && (recipe = PiglinBarteringRecipe.getRecipeFor(offhandStack, piglinEntity.field_70170_p.func_199532_z())) != null) {
            PiglinTasksMixin.func_234475_a_(piglinEntity, Collections.singletonList(recipe.assemble(piglinEntity.func_70681_au())));
            ci.cancel();
        }
    }

    @Inject(method={"throwItemsTowardRandomPos(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void throwItemsTowardRandomPosHandler(PiglinEntity piglinEntity, List<ItemStack> stacks, CallbackInfo ci) {
        piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220952_m).ifPresent(livingEntity -> {
            if (livingEntity instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)livingEntity;
                stacks.forEach(stack -> CrockPotCriteriaTriggers.PIGLIN_BARTERING_TRIGGER.trigger(serverPlayer, (ItemStack)stack));
            }
        });
    }

    @Inject(method={"throwItemsTowardPlayer(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/entity/player/PlayerEntity;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void throwItemsTowardPlayerHandler(PiglinEntity piglinEntity, PlayerEntity playerEntity, List<ItemStack> stacks, CallbackInfo ci) {
        if (playerEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerEntity;
            stacks.forEach(stack -> CrockPotCriteriaTriggers.PIGLIN_BARTERING_TRIGGER.trigger(serverPlayer, (ItemStack)stack));
        }
    }

    @Inject(method={"wantsToPickup(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="JUMP", ordinal=0, opcode=166)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void wantsToPickupHandler(PiglinEntity piglinEntity, ItemStack wantsToPickupStack, CallbackInfoReturnable<Boolean> cir, Item wantsToPickupItem) {
        if (!(wantsToPickupItem == Items.field_151074_bl || PiglinTasksMixin.func_234499_c_(wantsToPickupItem) || !PiglinTasksMixin.func_234480_a_(wantsToPickupItem) && ((IPiglinEntityMixin)piglinEntity).callCanReplaceCurrentItem(wantsToPickupStack) || PiglinBarteringRecipe.getRecipeFor(wantsToPickupStack, piglinEntity.field_70170_p.func_199532_z()) == null)) {
            cir.setReturnValue((Object)PiglinTasksMixin.func_234455_E_(piglinEntity));
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;split(I)Lnet/minecraft/item/ItemStack;", ordinal=0)})
    private static void modInteractHandler(PiglinEntity piglinEntity, PlayerEntity playerEntity, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        piglinEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220952_m, (Object)playerEntity);
    }

    @Inject(method={"canAdmire(Lnet/minecraft/entity/monster/piglin/PiglinEntity;Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canAdmireHandler(PiglinEntity piglinEntity, ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        Predicate<ItemStack> isSpecialBarteringStack = stack -> !stack.func_77973_b().func_206844_a((ITag)ItemTags.field_232902_M_) && !PiglinTasksMixin.func_234499_c_(stack.func_77973_b()) && PiglinBarteringRecipe.getRecipeFor(stack, piglinEntity.field_70170_p.func_199532_z()) != null;
        cir.setReturnValue((Object)(!PiglinTasksMixin.func_234453_C_(piglinEntity) && !PiglinTasksMixin.func_234451_A_(piglinEntity) && piglinEntity.func_242337_eM() && (itemStack.isPiglinCurrency() || isSpecialBarteringStack.test(itemStack)) ? 1 : 0));
    }

    @Inject(method={"isPlayerHoldingLovedItem(Lnet/minecraft/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isPlayerHoldingLovedItemHandler(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        Predicate<Item> isSpecialBarteringItem = item -> !item.func_206844_a((ITag)ItemTags.field_232902_M_) && !PiglinTasksMixin.func_234499_c_(item) && PiglinBarteringRecipe.getRecipeFor(item, livingEntity.field_70170_p.func_199532_z()) != null;
        cir.setReturnValue((Object)(livingEntity.func_200600_R() == EntityType.field_200729_aH && (livingEntity.func_233634_a_(PiglinTasksMixin::func_234480_a_) || livingEntity.func_233634_a_(isSpecialBarteringItem)) ? 1 : 0));
    }

    @Inject(method={"isNotHoldingLovedItemInOffHand(Lnet/minecraft/entity/monster/piglin/PiglinEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isNotHoldingLovedItemInOffHandHandler(PiglinEntity piglinEntity, CallbackInfoReturnable<Boolean> cir) {
        ItemStack offhandStack = piglinEntity.func_184592_cb();
        Predicate<ItemStack> isSpecialBarteringStack = stack -> !stack.func_77973_b().func_206844_a((ITag)ItemTags.field_232902_M_) && !PiglinTasksMixin.func_234499_c_(stack.func_77973_b()) && PiglinBarteringRecipe.getRecipeFor(stack, piglinEntity.field_70170_p.func_199532_z()) != null;
        cir.setReturnValue((Object)(offhandStack.func_190926_b() || !PiglinTasksMixin.func_234480_a_(offhandStack.func_77973_b()) && !isSpecialBarteringStack.test(offhandStack) ? 1 : 0));
    }
}

