/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.network;

import com.sihenzhang.crockpot.capability.FoodCounterCapabilityHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFoodCounter {
    private final CompoundNBT capabilityTag;

    public PacketFoodCounter(CompoundNBT capabilityTag) {
        this.capabilityTag = capabilityTag;
    }

    public static void serialize(PacketFoodCounter pack, PacketBuffer buf) {
        buf.func_150786_a(pack.capabilityTag);
    }

    public static PacketFoodCounter deserialize(PacketBuffer buf) {
        return new PacketFoodCounter(buf.func_150793_b());
    }

    public static void handle(PacketFoodCounter pack, Supplier<NetworkEvent.Context> ctx) {
        if (EffectiveSide.get().isClient()) {
            Handler.handle(pack, ctx);
        }
    }

    private static class Handler {
        private Handler() {
        }

        static void handle(PacketFoodCounter pack, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    player.getCapability(FoodCounterCapabilityHandler.FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> foodCounter.deserializeNBT((INBT)pack.capabilityTag));
                }
            });
            context.setPacketHandled(true);
        }
    }
}

