/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.util.JsonUtils;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExplosionCraftingRecipe
extends AbstractCrockPotRecipe {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float lossRate;
    private final boolean onlyBlock;

    public ExplosionCraftingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float lossRate, boolean onlyBlock) {
        super(id);
        ItemStack[] items;
        Ingredient dummyInput = ingredient;
        boolean inputHasBlockItem = false;
        if (onlyBlock && (inputHasBlockItem = Arrays.stream(items = ingredient.func_193365_a()).anyMatch(stack -> stack.func_77973_b() instanceof BlockItem))) {
            dummyInput = Ingredient.func_234819_a_(Arrays.stream(items).filter(stack -> stack.func_77973_b() instanceof BlockItem));
        }
        this.ingredient = dummyInput;
        this.result = result;
        this.lossRate = MathHelper.func_76131_a((float)lossRate, (float)0.0f, (float)1.0f);
        this.onlyBlock = inputHasBlockItem;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public float getLossRate() {
        return this.lossRate;
    }

    public boolean isOnlyBlock() {
        return this.onlyBlock;
    }

    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nullable
    public static ExplosionCraftingRecipe getRecipeFor(ItemStack stack, RecipeManager recipeManager) {
        return stack.func_190926_b() ? null : (ExplosionCraftingRecipe)recipeManager.func_241447_a_(CrockPotRecipeTypes.EXPLOSION_CRAFT_RECIPE_TYPE).stream().filter(r -> !r.isOnlyBlock() && r.matches(stack)).findAny().orElse(null);
    }

    @Nullable
    public static ExplosionCraftingRecipe getRecipeFor(BlockState state, RecipeManager recipeManager) {
        if (state == null) {
            return null;
        }
        Block block = state.func_177230_c();
        return block == Blocks.field_150350_a || !(block.func_199767_j() instanceof BlockItem) ? null : (ExplosionCraftingRecipe)recipeManager.func_241447_a_(CrockPotRecipeTypes.EXPLOSION_CRAFT_RECIPE_TYPE).stream().filter(r -> r.matches(block.func_199767_j().func_190903_i())).findAny().orElse(null);
    }

    public ItemStack assemble(Random rand) {
        if (MathUtils.fuzzyIsZero(this.lossRate)) {
            return this.result.func_77946_l();
        }
        if (this.result.func_190916_E() == 1) {
            return rand.nextFloat() >= this.lossRate ? this.result.func_77946_l() : ItemStack.field_190927_a;
        }
        int count = (int)rand.doubles(this.result.func_190916_E()).filter(d -> d >= (double)this.lossRate).count();
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = this.result.func_77946_l();
        output.func_190920_e(count);
        return output;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CrockPotRegistry.explosionCrafting;
    }

    public IRecipeType<?> func_222127_g() {
        return CrockPotRecipeTypes.EXPLOSION_CRAFT_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ExplosionCraftingRecipe> {
        public ExplosionCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(serializedRecipe, "ingredient");
            ItemStack result = JsonUtils.getAsItemStack(serializedRecipe, "result");
            float lossRate = MathHelper.func_76131_a((float)JSONUtils.func_151221_a((JsonObject)serializedRecipe, (String)"lossrate", (float)0.0f), (float)0.0f, (float)1.0f);
            boolean onlyBlock = JSONUtils.func_151209_a((JsonObject)serializedRecipe, (String)"onlyblock", (boolean)false);
            return new ExplosionCraftingRecipe(recipeId, ingredient, result, lossRate, onlyBlock);
        }

        @Nullable
        public ExplosionCraftingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            float lossRate = buffer.readFloat();
            boolean onlyBlock = buffer.readBoolean();
            return new ExplosionCraftingRecipe(recipeId, ingredient, result, lossRate, onlyBlock);
        }

        public void toNetwork(PacketBuffer buffer, ExplosionCraftingRecipe recipe) {
            recipe.getIngredient().func_199564_a(buffer);
            buffer.func_150788_a(recipe.getResult());
            buffer.writeFloat(recipe.getLossRate());
            buffer.writeBoolean(recipe.isOnlyBlock());
        }
    }
}

