/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FoodValuesDefinition
extends AbstractCrockPotRecipe {
    private final Set<ResourceLocation> names;
    private final FoodValues foodValues;
    private final boolean isTag;

    public FoodValuesDefinition(ResourceLocation id, Set<ResourceLocation> names, FoodValues foodValues, boolean isTag) {
        super(id);
        this.names = ImmutableSet.copyOf(names);
        this.foodValues = foodValues;
        this.isTag = isTag;
    }

    public Set<ResourceLocation> getNames() {
        return this.names;
    }

    public FoodValues getFoodValues() {
        return this.foodValues;
    }

    public boolean isTag() {
        return this.isTag;
    }

    @Nonnull
    public static FoodValues getFoodValues(Item item, RecipeManager recipeManager) {
        if (item == null || item == Items.field_190931_a) {
            return FoodValues.create();
        }
        List allDefs = recipeManager.func_241447_a_(CrockPotRecipeTypes.FOOD_VALUES_RECIPE_TYPE);
        Optional<FoodValuesDefinition> itemDef = allDefs.stream().filter(def -> !def.isTag() && def.getNames().stream().anyMatch(name -> name.equals((Object)item.getRegistryName()))).findFirst();
        if (itemDef.isPresent()) {
            return itemDef.get().getFoodValues();
        }
        FoodValues foodValues = FoodValues.create();
        long maxCount = -1L;
        HashMap tagDefs = new HashMap();
        allDefs.stream().filter(FoodValuesDefinition::isTag).forEach(tagDef -> tagDef.getNames().forEach(name -> tagDefs.put(name, tagDef.getFoodValues())));
        for (ResourceLocation tag : item.getTags()) {
            long count;
            if (!tagDefs.containsKey(tag) || (count = tag.toString().chars().filter(c -> c == 47).count()) < maxCount) continue;
            if (count > maxCount) {
                maxCount = count;
                foodValues.clear();
            }
            ((FoodValues)tagDefs.get(tag)).entrySet().forEach(entry -> foodValues.put((FoodCategory)((Object)((Object)entry.getKey())), Math.max(foodValues.get((FoodCategory)((Object)((Object)entry.getKey()))), ((Float)entry.getValue()).floatValue())));
        }
        return foodValues;
    }

    @Nonnull
    public static Set<Item> getMatchedItems(FoodCategory category, RecipeManager recipeManager) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((i1, i2) -> {
            float v2;
            ResourceLocation r1 = i1.getRegistryName();
            ResourceLocation r2 = i2.getRegistryName();
            String n1 = Objects.requireNonNull(r1).func_110624_b();
            String n2 = Objects.requireNonNull(r2).func_110624_b();
            float v1 = FoodValuesDefinition.getFoodValues(i1, recipeManager).get(category);
            if (MathUtils.fuzzyEquals(v1, v2 = FoodValuesDefinition.getFoodValues(i2, recipeManager).get(category))) {
                if ("minecraft".equals(n1)) {
                    return "minecraft".equals(n2) ? r1.compareTo(r2) : -1;
                }
                if ("minecraft".equals(n2)) {
                    return 1;
                }
                if ("crockpot".equals(n1)) {
                    return "crockpot".equals(n2) ? r1.compareTo(r2) : -1;
                }
                if ("crockpot".equals(n2)) {
                    return 1;
                }
                return r1.compareTo(r2);
            }
            return Float.compare(v1, v2);
        });
        List allDefs = recipeManager.func_241447_a_(CrockPotRecipeTypes.FOOD_VALUES_RECIPE_TYPE);
        allDefs.stream().filter(def -> !def.isTag()).forEach(itemDef -> itemDef.getNames().forEach(name -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
            if (item != null && item != Items.field_190931_a && itemDef.getFoodValues().has(category)) {
                builder.add((Object)item);
            }
        }));
        allDefs.stream().filter(FoodValuesDefinition::isTag).forEach(tagDef -> tagDef.getNames().forEach(name -> {
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(name);
            if (tag != null && tagDef.getFoodValues().has(category)) {
                Ingredient.TagList tagList = new Ingredient.TagList(tag);
                tagList.func_199799_a().forEach(stack -> {
                    Item item = stack.func_77973_b();
                    if (FoodValuesDefinition.getFoodValues(item, recipeManager).has(category)) {
                        builder.add((Object)item);
                    }
                });
            }
        }));
        return builder.build();
    }

    @Nonnull
    public static List<FoodCategoryMatchedItems> getFoodCategoryMatchedItemsList(RecipeManager recipeManager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FoodCategory category : FoodCategory.values()) {
            builder.add((Object)new FoodCategoryMatchedItems(category, FoodValuesDefinition.getMatchedItems(category, recipeManager)));
        }
        return builder.build();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CrockPotRegistry.foodValues;
    }

    public IRecipeType<?> func_222127_g() {
        return CrockPotRecipeTypes.FOOD_VALUES_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FoodValuesDefinition> {
        public FoodValuesDefinition fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            FoodValues foodValues = FoodValues.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)serializedRecipe, (String)"values"));
            if (serializedRecipe.has("items") && serializedRecipe.has("tags")) {
                throw new JsonParseException("A food value definition entry needs either tags or items, not both");
            }
            if (serializedRecipe.has("items") || serializedRecipe.has("tags")) {
                HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
                boolean isTag = serializedRecipe.has("tags");
                JSONUtils.func_151214_t((JsonObject)serializedRecipe, (String)(isTag ? "tags" : "items")).forEach(name -> names.add(new ResourceLocation(JSONUtils.func_151206_a((JsonElement)name, (String)(isTag ? "tag" : "item")))));
                return new FoodValuesDefinition(recipeId, names, foodValues, isTag);
            }
            throw new JsonParseException("A food value definition entry needs either tags or items");
        }

        @Nullable
        public FoodValuesDefinition fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            boolean isTag = buffer.readBoolean();
            HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
            int length = buffer.func_150792_a();
            for (int i = 0; i < length; ++i) {
                names.add(buffer.func_192575_l());
            }
            FoodValues foodValues = FoodValues.fromNetwork(buffer);
            return new FoodValuesDefinition(recipeId, names, foodValues, isTag);
        }

        public void toNetwork(PacketBuffer buffer, FoodValuesDefinition recipe) {
            buffer.writeBoolean(recipe.isTag());
            buffer.func_150787_b(recipe.getNames().size());
            recipe.getNames().forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
            recipe.getFoodValues().toNetwork(buffer);
        }
    }

    public static class FoodCategoryMatchedItems {
        private final FoodCategory category;
        private final Set<Item> items;

        public FoodCategoryMatchedItems(FoodCategory category, Set<Item> items) {
            this.category = category;
            this.items = items;
        }

        public FoodCategory getCategory() {
            return this.category;
        }

        public Set<Item> getItems() {
            return this.items;
        }
    }
}

