/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sihenzhang.crockpot.util.JsonUtils;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.WeightedRandom;

public class WeightedItem
extends WeightedRandom.Item {
    public final Item item;
    public final int min;
    public final int max;

    public WeightedItem(Item item, int min, int max, int weight) {
        super(Math.max(weight, 1));
        this.item = item;
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public WeightedItem(Item item, int count, int weight) {
        this(item, count, count, weight);
    }

    public WeightedItem(Item item, int weight) {
        this(item, 1, weight);
    }

    public boolean isRanged() {
        return this.min != this.max;
    }

    public boolean isEmpty() {
        return this.item == null || this.item == Items.field_190931_a || this.min <= 0 && this.max <= 0 || this.field_76292_a <= 0;
    }

    public static WeightedItem fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        JsonObject obj = JSONUtils.func_151210_l((JsonElement)json, (String)"weighted item");
        Item item = JsonUtils.getAsItem(obj, "item");
        if (item != null) {
            int weight = JSONUtils.func_151208_a((JsonObject)obj, (String)"weight", (int)1);
            if (obj.has("count")) {
                JsonElement e = obj.get("count");
                if (e.isJsonObject()) {
                    JsonObject count = e.getAsJsonObject();
                    if (count.has("min") && count.has("max")) {
                        int min = JSONUtils.func_151203_m((JsonObject)count, (String)"min");
                        int max = JSONUtils.func_151203_m((JsonObject)count, (String)"max");
                        return new WeightedItem(item, min, max, weight);
                    }
                    if (count.has("min")) {
                        int min = JSONUtils.func_151203_m((JsonObject)count, (String)"min");
                        return new WeightedItem(item, min, weight);
                    }
                    if (count.has("max")) {
                        int max = JSONUtils.func_151203_m((JsonObject)count, (String)"max");
                        return new WeightedItem(item, max, weight);
                    }
                    return new WeightedItem(item, weight);
                }
                int count = JSONUtils.func_151208_a((JsonObject)obj, (String)"count", (int)1);
                return new WeightedItem(item, count, weight);
            }
            return new WeightedItem(item, weight);
        }
        return null;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", Objects.requireNonNull(this.item.getRegistryName()).toString());
        if (this.isRanged()) {
            JsonObject count = new JsonObject();
            count.addProperty("min", (Number)this.min);
            count.addProperty("max", (Number)this.max);
            obj.add("count", (JsonElement)count);
        } else {
            obj.addProperty("count", (Number)this.min);
        }
        obj.addProperty("weight", (Number)this.field_76292_a);
        return obj;
    }

    public static WeightedItem fromNetwork(PacketBuffer buffer) {
        Item item = Item.func_150899_d((int)buffer.func_150792_a());
        byte min = buffer.readByte();
        byte max = buffer.readByte();
        int weight = buffer.func_150792_a();
        return new WeightedItem(item, min, max, weight);
    }

    public void toNetwork(PacketBuffer buffer) {
        buffer.func_150787_b(Item.func_150891_b((Item)this.item));
        buffer.writeByte(this.min);
        buffer.writeByte(this.max);
        buffer.func_150787_b(this.field_76292_a);
    }

    public static String getCountAndChance(WeightedItem weightedItem, List<WeightedItem> totalWeightedItems) {
        float chance = (float)weightedItem.field_76292_a / (float)WeightedRandom.func_76272_a(totalWeightedItems);
        StringBuilder chanceTooltip = new StringBuilder();
        if (weightedItem.isRanged()) {
            chanceTooltip.append(weightedItem.min).append("-").append(weightedItem.max);
        } else {
            chanceTooltip.append(weightedItem.min);
        }
        chanceTooltip.append(" (").append(StringUtils.format(chance, "0.00%")).append(")");
        return chanceTooltip.toString();
    }
}

