/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.bartering;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.recipe.WeightedItem;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PiglinBarteringRecipe
extends AbstractCrockPotRecipe {
    private final Ingredient ingredient;
    private final List<WeightedItem> weightedResults;

    public PiglinBarteringRecipe(ResourceLocation id, Ingredient ingredient, List<WeightedItem> weightedResults) {
        super(id);
        this.ingredient = ingredient;
        ArrayList<WeightedItem> tmpWeightedResults = new ArrayList<WeightedItem>();
        weightedResults.forEach(weightedItem -> {
            WeightedItem dummy = null;
            Iterator iterator = tmpWeightedResults.iterator();
            while (iterator.hasNext()) {
                WeightedItem e = (WeightedItem)((Object)((Object)iterator.next()));
                if (e.item != weightedItem.item || e.min != weightedItem.min || e.max != weightedItem.max) continue;
                dummy = new WeightedItem(e.item, e.min, e.max, e.field_76292_a + weightedItem.field_76292_a);
                iterator.remove();
            }
            tmpWeightedResults.add(dummy != null ? dummy : weightedItem);
        });
        tmpWeightedResults.sort(Comparator.comparingInt(e -> e.field_76292_a).reversed());
        this.weightedResults = ImmutableList.copyOf(tmpWeightedResults);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<WeightedItem> getWeightedResults() {
        return this.weightedResults;
    }

    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nullable
    public static PiglinBarteringRecipe getRecipeFor(ItemStack stack, RecipeManager recipeManager) {
        return stack.func_190926_b() ? null : (PiglinBarteringRecipe)recipeManager.func_241447_a_(CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE).stream().filter(r -> r.matches(stack)).findFirst().orElse(null);
    }

    @Nullable
    public static PiglinBarteringRecipe getRecipeFor(Item item, RecipeManager recipeManager) {
        return item == null || item == Items.field_190931_a ? null : (PiglinBarteringRecipe)recipeManager.func_241447_a_(CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE).stream().filter(r -> r.matches(item.func_190903_i())).findFirst().orElse(null);
    }

    public ItemStack assemble(Random rand) {
        WeightedItem weightedItem = (WeightedItem)WeightedRandom.func_76271_a((Random)rand, this.weightedResults);
        if (weightedItem.isRanged()) {
            return new ItemStack((IItemProvider)weightedItem.item, MathHelper.func_76136_a((Random)rand, (int)weightedItem.min, (int)weightedItem.max));
        }
        return new ItemStack((IItemProvider)weightedItem.item, weightedItem.min);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CrockPotRegistry.piglinBartering;
    }

    public IRecipeType<?> func_222127_g() {
        return CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PiglinBarteringRecipe> {
        public PiglinBarteringRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(serializedRecipe, "ingredient");
            ArrayList<WeightedItem> weightedResults = new ArrayList<WeightedItem>();
            JsonArray results = JSONUtils.func_151214_t((JsonObject)serializedRecipe, (String)"results");
            results.forEach(result -> {
                WeightedItem weightedItem = WeightedItem.fromJson(result);
                if (weightedItem != null && !weightedItem.isEmpty()) {
                    weightedResults.add(weightedItem);
                }
            });
            return new PiglinBarteringRecipe(recipeId, ingredient, weightedResults);
        }

        @Nullable
        public PiglinBarteringRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ArrayList<WeightedItem> weightedResults = new ArrayList<WeightedItem>();
            int length = buffer.func_150792_a();
            for (int i = 0; i < length; ++i) {
                weightedResults.add(WeightedItem.fromNetwork(buffer));
            }
            return new PiglinBarteringRecipe(recipeId, ingredient, weightedResults);
        }

        public void toNetwork(PacketBuffer buffer, PiglinBarteringRecipe recipe) {
            recipe.getIngredient().func_199564_a(buffer);
            buffer.func_150787_b(recipe.getWeightedResults().size());
            recipe.getWeightedResults().forEach(weightedItem -> weightedItem.toNetwork(buffer));
        }
    }
}

