/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrockPotCookingRecipe
extends AbstractCrockPotRecipe {
    private final List<IRequirement> requirements;
    private final ItemStack result;
    private final int priority;
    private final int weight;
    private final int cookingTime;
    private final int potLevel;

    public CrockPotCookingRecipe(ResourceLocation id, List<IRequirement> requirements, ItemStack result, int priority, int weight, int cookingTime, int potLevel) {
        super(id);
        this.requirements = ImmutableList.copyOf(requirements);
        this.result = result;
        this.priority = priority;
        this.weight = Math.max(weight, 1);
        this.cookingTime = cookingTime;
        this.potLevel = potLevel;
    }

    public List<IRequirement> getRequirements() {
        return this.requirements;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    public boolean matches(CrockPotCookingRecipeInput input) {
        return input.potLevel >= this.potLevel && this.requirements.stream().allMatch(r -> r.test(input));
    }

    @Nullable
    public static CrockPotCookingRecipe getRecipeFor(CrockPotCookingRecipeInput input, Random random, RecipeManager recipeManager) {
        List recipes = recipeManager.func_241447_a_(CrockPotRecipeTypes.CROCK_POT_COOKING_RECIPE_TYPE);
        recipes.sort(Comparator.comparing(CrockPotCookingRecipe::getPriority).reversed());
        ArrayList<CrockPotCookingRecipe> matchedRecipes = new ArrayList<CrockPotCookingRecipe>();
        boolean isFirst = true;
        int priority = 0;
        for (CrockPotCookingRecipe recipe : recipes) {
            if (isFirst) {
                if (!recipe.matches(input)) continue;
                priority = recipe.getPriority();
                matchedRecipes.add(recipe);
                isFirst = false;
                continue;
            }
            if (recipe.getPriority() != priority) break;
            if (!recipe.matches(input)) continue;
            matchedRecipes.add(recipe);
        }
        if (matchedRecipes.isEmpty()) {
            return null;
        }
        int weightSum = matchedRecipes.stream().mapToInt(CrockPotCookingRecipe::getWeight).sum();
        int rand = random.nextInt(weightSum) + 1;
        for (CrockPotCookingRecipe matchedRecipe : matchedRecipes) {
            if ((rand -= matchedRecipe.getWeight()) > 0) continue;
            return matchedRecipe;
        }
        return null;
    }

    public ItemStack assemble() {
        return this.result.func_77946_l();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CrockPotRegistry.crockPotCooking;
    }

    public IRecipeType<?> func_222127_g() {
        return CrockPotRecipeTypes.CROCK_POT_COOKING_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrockPotCookingRecipe> {
        public CrockPotCookingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
            JSONUtils.func_151214_t((JsonObject)serializedRecipe, (String)"requirements").forEach(requirement -> requirements.add(IRequirement.fromJson(requirement)));
            ItemStack result = JsonUtils.getAsItemStack(serializedRecipe, "result");
            int priority = JSONUtils.func_151203_m((JsonObject)serializedRecipe, (String)"priority");
            int weight = JSONUtils.func_151208_a((JsonObject)serializedRecipe, (String)"weight", (int)1);
            int cookingTime = JSONUtils.func_151203_m((JsonObject)serializedRecipe, (String)"cookingtime");
            int potLevel = JSONUtils.func_151203_m((JsonObject)serializedRecipe, (String)"potlevel");
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        @Nullable
        public CrockPotCookingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
            int length = buffer.func_150792_a();
            for (int i = 0; i < length; ++i) {
                requirements.add(IRequirement.fromNetwork(buffer));
            }
            ItemStack result = buffer.func_150791_c();
            int priority = buffer.func_150792_a();
            int weight = buffer.func_150792_a();
            int cookingTime = buffer.func_150792_a();
            byte potLevel = buffer.readByte();
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        public void toNetwork(PacketBuffer buffer, CrockPotCookingRecipe recipe) {
            buffer.func_150787_b(recipe.getRequirements().size());
            recipe.getRequirements().forEach(requirement -> requirement.toNetwork(buffer));
            buffer.func_150788_a(recipe.getResult());
            buffer.func_150787_b(recipe.getPriority());
            buffer.func_150787_b(recipe.getWeight());
            buffer.func_150787_b(recipe.getCookingTime());
            buffer.writeByte(recipe.getPotLevel());
        }
    }
}

