/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationAnd;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationOr;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public interface IRequirement
extends Predicate<CrockPotCookingRecipeInput> {
    public static IRequirement fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        JsonObject object = JSONUtils.func_151210_l((JsonElement)json, (String)"requirement");
        RequirementType type = JsonUtils.getAsEnum(object, "type", RequirementType.class);
        switch (type) {
            case CATEGORY_MAX: {
                return RequirementCategoryMax.fromJson(object);
            }
            case CATEGORY_MAX_EXCLUSIVE: {
                return RequirementCategoryMaxExclusive.fromJson(object);
            }
            case CATEGORY_MIN: {
                return RequirementCategoryMin.fromJson(object);
            }
            case CATEGORY_MIN_EXCLUSIVE: {
                return RequirementCategoryMinExclusive.fromJson(object);
            }
            case MUST_CONTAIN_INGREDIENT: {
                return RequirementMustContainIngredient.fromJson(object);
            }
            case MUST_CONTAIN_INGREDIENT_LESS_THAN: {
                return RequirementMustContainIngredientLessThan.fromJson(object);
            }
            case COMBINATION_AND: {
                return RequirementCombinationAnd.fromJson(object);
            }
            case COMBINATION_OR: {
                return RequirementCombinationOr.fromJson(object);
            }
        }
        throw new IllegalArgumentException("No valid requirement type was found");
    }

    public JsonElement toJson();

    public static IRequirement fromNetwork(PacketBuffer buffer) {
        RequirementType type = (RequirementType)buffer.func_179257_a(RequirementType.class);
        switch (type) {
            case CATEGORY_MAX: {
                return RequirementCategoryMax.fromNetwork(buffer);
            }
            case CATEGORY_MAX_EXCLUSIVE: {
                return RequirementCategoryMaxExclusive.fromNetwork(buffer);
            }
            case CATEGORY_MIN: {
                return RequirementCategoryMin.fromNetwork(buffer);
            }
            case CATEGORY_MIN_EXCLUSIVE: {
                return RequirementCategoryMinExclusive.fromNetwork(buffer);
            }
            case MUST_CONTAIN_INGREDIENT: {
                return RequirementMustContainIngredient.fromNetwork(buffer);
            }
            case MUST_CONTAIN_INGREDIENT_LESS_THAN: {
                return RequirementMustContainIngredientLessThan.fromNetwork(buffer);
            }
            case COMBINATION_AND: {
                return RequirementCombinationAnd.fromNetwork(buffer);
            }
            case COMBINATION_OR: {
                return RequirementCombinationOr.fromNetwork(buffer);
            }
        }
        throw new IllegalArgumentException("No valid requirement type was found");
    }

    public void toNetwork(PacketBuffer var1);
}

