/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class RequirementCombinationAnd
implements IRequirement {
    private final IRequirement first;
    private final IRequirement second;

    public RequirementCombinationAnd(IRequirement first, IRequirement second) {
        this.first = first;
        this.second = second;
    }

    public IRequirement getFirst() {
        return this.first;
    }

    public IRequirement getSecond() {
        return this.second;
    }

    @Override
    public boolean test(CrockPotCookingRecipeInput recipeInput) {
        return this.first.test(recipeInput) && this.second.test(recipeInput);
    }

    public static RequirementCombinationAnd fromJson(JsonObject object) {
        IRequirement first = IRequirement.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"first"));
        IRequirement second = IRequirement.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"second"));
        return new RequirementCombinationAnd(first, second);
    }

    @Override
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", RequirementType.COMBINATION_AND.name());
        obj.add("first", this.first.toJson());
        obj.add("second", this.second.toJson());
        return obj;
    }

    public static RequirementCombinationAnd fromNetwork(PacketBuffer buffer) {
        return new RequirementCombinationAnd(IRequirement.fromNetwork(buffer), IRequirement.fromNetwork(buffer));
    }

    @Override
    public void toNetwork(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)RequirementType.COMBINATION_AND);
        this.first.toNetwork(buffer);
        this.second.toNetwork(buffer);
    }
}

