/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.tile;

import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.container.CrockPotContainer;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CrockPotTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot < 4 ? !CrockPotTileEntity.this.isValidIngredient(stack) : slot == 4 && !CrockPotTileEntity.isFuel(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CrockPotTileEntity.this.hasChanged = true;
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 4);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 5);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 5, 6);
    private int burningTime;
    private int burningTotalTime;
    private int cookingTime;
    private int cookingTotalTime;
    private ItemStack result = ItemStack.field_190927_a;
    private boolean hasChanged;
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerInputCap = LazyOptional.of(() -> this.itemHandlerInput);
    private final LazyOptional<IItemHandler> itemHandlerFuelCap = LazyOptional.of(() -> this.itemHandlerFuel);
    private final LazyOptional<IItemHandler> itemHandlerOutputCap = LazyOptional.of(() -> this.itemHandlerOutput);

    public CrockPotTileEntity() {
        super(CrockPotRegistry.crockPotTileEntity);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.crockpot.crock_pot");
    }

    @Nullable
    public Container createMenu(int containerId, PlayerInventory inventory, PlayerEntity player) {
        return new CrockPotContainer(containerId, inventory, this);
    }

    public void func_73660_a() {
        boolean isBurning = this.isBurning();
        if (this.isBurning()) {
            --this.burningTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            CrockPotCookingRecipe recipe;
            CrockPotCookingRecipeInput recipeInput;
            if ((this.isBurning() || this.canConsumeFuel()) && !this.isCooking() && this.itemHandlerOutput.getStackInSlot(0).func_190926_b() && (recipeInput = this.getRecipeInput()) != null && (recipe = CrockPotCookingRecipe.getRecipeFor(recipeInput, this.field_145850_b.field_73012_v, this.field_145850_b.func_199532_z())) != null) {
                this.cookingTotalTime = this.getActualCookingTotalTime(recipe);
                this.result = recipe.assemble();
                this.shrinkInputs();
                this.hasChanged = true;
            }
            if (this.canConsumeFuel() && this.isCooking()) {
                ItemStack fuelStack = this.itemHandlerFuel.getStackInSlot(0);
                ItemStack tmpFuelStack = fuelStack.func_77946_l();
                tmpFuelStack.func_190920_e(1);
                this.burningTime = this.burningTotalTime = ForgeHooks.getBurnTime((ItemStack)tmpFuelStack, null);
                fuelStack.func_190918_g(1);
                if (fuelStack.func_190926_b()) {
                    this.itemHandlerFuel.setStackInSlot(0, tmpFuelStack.getContainerItem());
                }
                this.hasChanged = true;
            }
            if (this.isBurning() && this.isCooking() && this.itemHandlerOutput.getStackInSlot(0).func_190926_b()) {
                ++this.cookingTime;
                if (this.cookingTime == this.cookingTotalTime) {
                    this.cookingTime = 0;
                    this.itemHandlerOutput.setStackInSlot(0, this.result);
                    this.result = ItemStack.field_190927_a;
                }
                this.hasChanged = true;
            }
            if (isBurning != this.isBurning()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)CrockPotBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            this.markUpdated();
            this.hasChanged = false;
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getPotLevel() {
        return ((CrockPotBlock)this.func_195044_w().func_177230_c()).getPotLevel();
    }

    @Nullable
    public CrockPotCookingRecipeInput getRecipeInput() {
        int size = this.itemHandlerInput.getSlots();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stackInSlot = this.itemHandlerInput.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) {
                return null;
            }
            ItemStack stack2 = stackInSlot.func_77946_l();
            stack2.func_190920_e(1);
            stacks.add(stack2);
        }
        FoodValues mergedFoodValues = FoodValues.merge(stacks.stream().map(stack -> FoodValuesDefinition.getFoodValues(stack.func_77973_b(), this.field_145850_b.func_199532_z())).collect(Collectors.toList()));
        return new CrockPotCookingRecipeInput(mergedFoodValues, stacks, this.getPotLevel());
    }

    public boolean isValidIngredient(ItemStack stack) {
        return !FoodValuesDefinition.getFoodValues(stack.func_77973_b(), this.field_145850_b.func_199532_z()).isEmpty();
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public boolean isBurning() {
        return this.burningTime > 0;
    }

    public float getBurningProgress() {
        return this.burningTotalTime != 0 ? (float)this.burningTime / (float)this.burningTotalTime : 0.0f;
    }

    public boolean isCooking() {
        return this.result != null && !this.result.func_190926_b();
    }

    public float getCookingProgress() {
        return this.cookingTotalTime != 0 ? (float)this.cookingTime / (float)this.cookingTotalTime : 0.0f;
    }

    public ItemStack getResult() {
        return this.result;
    }

    private boolean canConsumeFuel() {
        ItemStack fuelStack;
        if (!this.isBurning() && !(fuelStack = this.itemHandlerFuel.getStackInSlot(0)).func_190926_b()) {
            ItemStack tmpFuelStack = fuelStack.func_77946_l();
            tmpFuelStack.func_190920_e(1);
            return ForgeHooks.getBurnTime((ItemStack)tmpFuelStack, null) > 0;
        }
        return false;
    }

    private void shrinkInputs() {
        for (int i = 0; i < this.itemHandlerInput.getSlots(); ++i) {
            this.itemHandlerInput.getStackInSlot(i).func_190918_g(1);
        }
    }

    private int getActualCookingTotalTime(CrockPotCookingRecipe recipe) {
        return Math.max((int)((double)recipe.getCookingTime() * (1.0 - (Double)CrockPotConfig.CROCK_POT_SPEED_MODIFIER.get() * (double)this.getPotLevel())), 1);
    }

    private void sendTileEntityUpdatePacket() {
        SUpdateTileEntityPacket pkt;
        if (!this.field_145850_b.field_72995_K && (pkt = this.func_189518_D_()) != null) {
            ((ServerWorld)this.field_145850_b).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(this.field_174879_c), false).forEach(p -> p.field_71135_a.func_147359_a((IPacket)pkt));
        }
    }

    private void markUpdated() {
        this.func_70296_d();
        this.sendTileEntityUpdatePacket();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("ItemHandler"));
        this.burningTime = tag.func_74762_e("BurningTime");
        this.burningTotalTime = tag.func_74762_e("BurningTotalTime");
        this.cookingTime = tag.func_74762_e("CookingTime");
        this.cookingTotalTime = tag.func_74762_e("CookingTotalTime");
        this.result.deserializeNBT(tag.func_74775_l("Result"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        tag.func_74768_a("BurningTime", this.burningTime);
        tag.func_74768_a("BurningTotalTime", this.burningTotalTime);
        tag.func_74768_a("CookingTime", this.cookingTime);
        tag.func_74768_a("CookingTotalTime", this.cookingTotalTime);
        tag.func_218657_a("Result", (INBT)this.result.serializeNBT());
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemHandlerCap.cast();
            }
            switch (side) {
                case UP: {
                    return this.itemHandlerInputCap.cast();
                }
                case DOWN: {
                    return this.itemHandlerOutputCap.cast();
                }
            }
            return this.itemHandlerFuelCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

