/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;

public final class JsonUtils {
    public static final Gson GSON = new GsonBuilder().create();

    public static boolean isStringValue(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isString();
    }

    @Nullable
    public static Item convertToItem(JsonElement json, String memberName) {
        if (JsonUtils.isStringValue(json)) {
            String s = json.getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            return item == Items.field_190931_a ? null : item;
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + JSONUtils.func_151222_d((JsonElement)json));
    }

    @Nullable
    public static Item getAsItem(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonUtils.convertToItem(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    public static ItemStack convertToItemStack(JsonElement json, String memberName) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            return ShapedRecipe.func_199798_a((JsonObject)object);
        }
        if (JsonUtils.isStringValue(json)) {
            Item item = JSONUtils.func_188172_b((JsonElement)json, (String)memberName);
            return item.func_190903_i();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item stack, was " + JSONUtils.func_151222_d((JsonElement)json));
    }

    public static ItemStack getAsItemStack(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonUtils.convertToItemStack(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item stack");
    }

    @Nonnull
    public static Ingredient getAsIngredient(JsonObject json, String memberName) {
        return JsonUtils.getAsIngredient(json, memberName, false);
    }

    public static Ingredient getAsIngredient(JsonObject json, String memberName, boolean skip) {
        if (json.has(memberName)) {
            if (skip) {
                if (json.get(memberName).isJsonArray()) {
                    JsonArray array = json.getAsJsonArray(memberName);
                    JsonArray result = new JsonArray();
                    for (JsonElement e : array) {
                        ResourceLocation name;
                        JsonObject obj = JSONUtils.func_151210_l((JsonElement)e, (String)"item");
                        if (obj.has("item") && obj.has("tag")) {
                            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
                        }
                        if (obj.has("item")) {
                            name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"item"));
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
                            if (item == null || item == Items.field_190931_a) {
                                continue;
                            }
                        } else if (obj.has("tag")) {
                            name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"tag"));
                            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(name);
                            if (tag == null) {
                                continue;
                            }
                        } else {
                            throw new JsonParseException("An ingredient entry needs either a tag or an item");
                        }
                        result.add(e);
                    }
                    return Ingredient.func_199802_a((JsonElement)result);
                }
                return Ingredient.func_199802_a((JsonElement)json.get(memberName));
            }
            return Ingredient.func_199802_a((JsonElement)json.get(memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an ingredient");
    }

    public static <E extends Enum<E>> E convertToEnum(JsonElement json, String memberName, Class<E> enumClass) {
        if (JsonUtils.isStringValue(json)) {
            String enumName = JSONUtils.func_151206_a((JsonElement)json, (String)memberName).toUpperCase();
            if (!EnumUtils.isValidEnum(enumClass, (String)enumName)) {
                throw new JsonSyntaxException("Expected " + memberName + " to be an enum of " + enumClass.getName() + ", was unknown name: '" + enumName + "'");
            }
            return (E)EnumUtils.getEnum(enumClass, (String)enumName);
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an enum of " + enumClass.getName() + ", was" + JSONUtils.func_151222_d((JsonElement)json));
    }

    public static <E extends Enum<E>> E getAsEnum(JsonObject json, String memberName, Class<E> enumClass) {
        if (json.has(memberName)) {
            return JsonUtils.convertToEnum(json.get(memberName), memberName, enumClass);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an enum");
    }
}

