/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LootTableUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void addEntryToLootTable(LootTable lootTable, String poolName, LootEntry ... lootEntries) {
        LootPool pool = Objects.requireNonNull(lootTable.getPool(poolName));
        try {
            for (LootEntry lootEntry : lootEntries) {
                LootTableUtils.addEntryToLootPool(pool, lootEntry);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error occurred when attempting to add a new entry to \"" + lootTable.getLootTableId() + "\" loot table", (Throwable)e);
        }
    }

    public static void addEntryToLootTable(LootTable lootTable, LootEntry ... lootEntries) {
        LootTableUtils.addEntryToLootTable(lootTable, "main", lootEntries);
    }

    private static void addEntryToLootPool(LootPool lootPool, LootEntry lootEntry) throws IllegalAccessException {
        List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(lootPool);
        if (lootEntries.stream().anyMatch(e -> e == lootEntry)) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + lootEntry);
        }
        lootEntries.add(lootEntry);
    }
}

