/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.Reader;
import java.io.StringReader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class NbtUtils {
    public static JsonElement convertToJson(INBT nbt) {
        JsonReader reader = new JsonReader((Reader)new StringReader(nbt.toString()));
        reader.setLenient(true);
        return new JsonParser().parse(reader);
    }

    public static INBT writeIngredient(Ingredient ingredient) throws CommandSyntaxException {
        JsonElement json = ingredient.func_200304_c();
        if (json.isJsonObject()) {
            return JsonToNBT.func_180713_a((String)json.toString());
        }
        ListNBT list = new ListNBT();
        for (JsonElement e : json.getAsJsonArray()) {
            list.add((Object)JsonToNBT.func_180713_a((String)e.toString()));
        }
        return list;
    }

    public static Ingredient readIngredient(INBT nbt) {
        Preconditions.checkArgument((nbt != null ? 1 : 0) != 0, (Object)"Ingredient cannot be null");
        if (nbt.func_225647_b_() == ListNBT.field_229694_a_) {
            ListNBT list = (ListNBT)nbt;
            ListNBT result = new ListNBT();
            for (INBT e : list) {
                String name;
                Preconditions.checkArgument((e.func_225647_b_() == CompoundNBT.field_229675_a_ ? 1 : 0) != 0, (Object)"Expcted ingredient to be a object or array of objects");
                CompoundNBT compound = (CompoundNBT)e;
                if (compound.func_74764_b("item") && compound.func_74764_b("tag")) {
                    throw new IllegalArgumentException("An ingredient entry is either a tag or an item, not both");
                }
                if (compound.func_74764_b("item")) {
                    name = compound.func_74779_i("item");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                    if (item == null || item == Items.field_190931_a) {
                        continue;
                    }
                } else if (compound.func_74764_b("tag")) {
                    name = compound.func_74779_i("tag");
                    ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(name));
                    if (tag == null) {
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException("An ingredient entry needs either a tag or an item");
                }
                result.add((Object)e);
            }
            return Ingredient.func_199802_a((JsonElement)NbtUtils.convertToJson((INBT)result));
        }
        return Ingredient.func_199802_a((JsonElement)NbtUtils.convertToJson(nbt));
    }

    public static ItemStack setLoreString(ItemStack stack, String string) {
        CompoundNBT displayTag = new CompoundNBT();
        CompoundNBT loreTag = new CompoundNBT();
        ListNBT loreListTag = new ListNBT();
        loreListTag.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + string + "\"}")));
        loreTag.func_218657_a("Lore", (INBT)loreListTag);
        displayTag.func_218657_a("display", (INBT)loreTag);
        stack.func_77982_d(displayTag);
        return stack;
    }
}

