/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.world;

import com.mojang.serialization.Codec;
import com.sihenzhang.crockpot.block.CrockPotDoubleCropsBlock;
import com.sihenzhang.crockpot.world.CrockPotCropsFeatureConfig;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

@ParametersAreNonnullByDefault
public class CrockPotCropsFeature
extends Feature<CrockPotCropsFeatureConfig> {
    public CrockPotCropsFeature(Codec<CrockPotCropsFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, CrockPotCropsFeatureConfig config) {
        int age = rand.nextInt(8);
        int dist = MathHelper.func_76125_a((int)config.spreadRadius, (int)1, (int)8);
        boolean any = false;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (int i = 0; i < config.tryCount && !any; ++i) {
            int x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)-8, (int)8);
            int z = pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)-8, (int)8);
            int y = reader.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
            mutableBlockPos.func_181079_c(x, y, z);
            BlockPos posDown = mutableBlockPos.func_177977_b();
            BlockState stateDown = reader.func_180495_p(posDown);
            if (!reader.func_175623_d((BlockPos)mutableBlockPos) || !config.whitelist.isEmpty() && !config.whitelist.contains(stateDown.func_177230_c())) continue;
            reader.func_180501_a(posDown, config.replacementBlock.func_176223_P(), 2);
            if (config.cropsBlock instanceof CrockPotDoubleCropsBlock && age > 3) {
                reader.func_180501_a((BlockPos)mutableBlockPos, config.cropsBlock.func_185528_e(3), 2);
                reader.func_180501_a(mutableBlockPos.func_177984_a(), config.cropsBlock.func_185528_e(age), 2);
            } else {
                reader.func_180501_a((BlockPos)mutableBlockPos, config.cropsBlock.func_185528_e(age), 2);
            }
            any = true;
        }
        return any;
    }
}

