/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.world;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CrockPotCropsFeatureConfig
implements IFeatureConfig {
    public static final Codec<CrockPotCropsFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("state_provider").forGetter(config -> config.cropsBlock.func_176223_P()), (App)BlockState.field_235877_b_.listOf().fieldOf("whitelist").orElse((Object)ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P()).asList()).forGetter(config -> config.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList())), (App)BlockState.field_235877_b_.fieldOf("replacement_block").orElse((Object)Blocks.field_150458_ak.func_176223_P()).forGetter(config -> config.replacementBlock.func_176223_P()), (App)Codec.INT.fieldOf("tries").orElse((Object)32).forGetter(config -> config.tryCount), (App)Codec.INT.fieldOf("spread_radius").orElse((Object)2).forGetter(config -> config.spreadRadius)).apply((Applicative)instance, CrockPotCropsFeatureConfig::new));
    public final CrockPotCropsBlock cropsBlock;
    public final Set<Block> whitelist;
    public final Block replacementBlock;
    public final int tryCount;
    public final int spreadRadius;

    private CrockPotCropsFeatureConfig(BlockState cropsBlock, List<BlockState> whitelist, BlockState replacedBlock, int tryCount, int spreadRadius) {
        this((CrockPotCropsBlock)cropsBlock.func_177230_c(), whitelist.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).collect(Collectors.toSet()), replacedBlock.func_177230_c(), tryCount, spreadRadius);
    }

    private CrockPotCropsFeatureConfig(CrockPotCropsBlock cropsBlock, Set<Block> whitelist, Block replacementBlock, int tryCount, int spreadRadius) {
        this.cropsBlock = cropsBlock;
        this.whitelist = whitelist;
        this.replacementBlock = replacementBlock;
        this.tryCount = tryCount;
        this.spreadRadius = spreadRadius;
    }

    public static CrockPotCropsFeatureConfigBuilder builder(CrockPotCropsBlock cropsBlock) {
        return new CrockPotCropsFeatureConfigBuilder(cropsBlock);
    }

    public static class CrockPotCropsFeatureConfigBuilder {
        private final CrockPotCropsBlock cropsBlock;
        private Set<Block> whitelist = ImmutableSet.of((Object)Blocks.field_196658_i.getBlock());
        private Block replacementBlock = Blocks.field_150458_ak;
        private int tryCount = 64;
        private int spreadRadius = 2;

        public CrockPotCropsFeatureConfigBuilder(CrockPotCropsBlock cropsBlock) {
            this.cropsBlock = cropsBlock;
        }

        public CrockPotCropsFeatureConfigBuilder whitelist(Set<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder replacedBy(Block replacementBlock) {
            this.replacementBlock = replacementBlock;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder tries(int tryCount) {
            this.tryCount = tryCount;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder spreadRadius(int spreadRadius) {
            this.spreadRadius = spreadRadius;
            return this;
        }

        public CrockPotCropsFeatureConfig build() {
            return new CrockPotCropsFeatureConfig(this.cropsBlock, this.whitelist, this.replacementBlock, this.tryCount, this.spreadRadius);
        }
    }
}

