/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.world;

import com.google.common.collect.ImmutableSet;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import com.sihenzhang.crockpot.world.CrockPotCropsFeatureConfig;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crockpot")
public class CrockPotFeatures {
    public static final CrockPotCropsFeatureConfig ASPARAGUS_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.asparagusBlock).build();
    public static final CrockPotCropsFeatureConfig CORN_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.cornBlock).build();
    public static final CrockPotCropsFeatureConfig EGGPLANT_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.eggplantBlock).build();
    public static final CrockPotCropsFeatureConfig ONION_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.onionBlock).build();
    public static final CrockPotCropsFeatureConfig PEPPER_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.pepperBlock).whitelist((Set<Block>)ImmutableSet.of((Object)Blocks.field_196658_i, (Object)Blocks.field_196660_k)).build();
    public static final CrockPotCropsFeatureConfig TOMATO_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((CrockPotCropsBlock)CrockPotRegistry.tomatoBlock).build();
    public static final ConfiguredFeature<?, ?> PATCH_ASPARAGUS = CrockPotFeatures.register("patch_asparagus", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)ASPARAGUS_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.ASPARAGUS_GENERATION_CHANCE.get()).intValue()));
    public static final ConfiguredFeature<?, ?> PATCH_CORN = CrockPotFeatures.register("patch_corn", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)CORN_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.CORN_GENERATION_CHANCE.get()).intValue()));
    public static final ConfiguredFeature<?, ?> PATCH_EGGPLANT = CrockPotFeatures.register("patch_eggplant", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)EGGPLANT_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.EGGPLANT_GENERATION_CHANCE.get()).intValue()));
    public static final ConfiguredFeature<?, ?> PATCH_ONION = CrockPotFeatures.register("patch_onion", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)ONION_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.ONION_GENERATION_CHANCE.get()).intValue()));
    public static final ConfiguredFeature<?, ?> PATCH_PEPPER = CrockPotFeatures.register("patch_pepper", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)PEPPER_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.PEPPER_GENERATION_CHANCE.get()).intValue()));
    public static final ConfiguredFeature<?, ?> PATCH_TOMATO = CrockPotFeatures.register("patch_tomato", (ConfiguredFeature)CrockPotRegistry.cropsPatchFeature.func_225566_b_((IFeatureConfig)TOMATO_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(((Integer)CrockPotConfig.TOMATO_GENERATION_CHANCE.get()).intValue()));

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("crockpot", key), configuredFeature);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)CrockPotConfig.ENABLE_WORLD_GENERATION.get()).booleanValue()) {
            Biome.Category category = event.getCategory();
            BiomeGenerationSettingsBuilder builder = event.getGeneration();
            if (((Boolean)CrockPotConfig.ASPARAGUS_GENERATION.get()).booleanValue() && (event.getName().func_110623_a().startsWith("dark_forest") || category == Biome.Category.SWAMP)) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_ASPARAGUS);
            }
            if (((Boolean)CrockPotConfig.CORN_GENERATION.get()).booleanValue() && category == Biome.Category.FOREST) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_CORN);
            }
            if (((Boolean)CrockPotConfig.EGGPLANT_GENERATION.get()).booleanValue() && (category == Biome.Category.PLAINS || category == Biome.Category.FOREST)) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_EGGPLANT);
            }
            if (((Boolean)CrockPotConfig.ONION_GENERATION.get()).booleanValue() && category == Biome.Category.SAVANNA) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_ONION);
            }
            if (((Boolean)CrockPotConfig.PEPPER_GENERATION.get()).booleanValue() && (category == Biome.Category.SAVANNA || category == Biome.Category.MESA)) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_PEPPER);
            }
            if (((Boolean)CrockPotConfig.TOMATO_GENERATION.get()).booleanValue() && category == Biome.Category.PLAINS) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PATCH_TOMATO);
            }
        }
    }
}

