/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot;

import com.google.common.collect.ImmutableSet;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.AbstractCrockPotBlock;
import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.block.CornBlock;
import com.sihenzhang.crockpot.block.CrockPotUnknownCropsBlock;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.effect.CrockPotEffect;
import com.sihenzhang.crockpot.inventory.CrockPotMenu;
import com.sihenzhang.crockpot.item.CollectedDustItem;
import com.sihenzhang.crockpot.item.CreativeMilkmadeHatItem;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotSeedsItem;
import com.sihenzhang.crockpot.item.CrockPotUnknownSeedsItem;
import com.sihenzhang.crockpot.item.GnawsCoinItem;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.item.NetherosiaItem;
import com.sihenzhang.crockpot.item.food.Candy;
import com.sihenzhang.crockpot.item.food.CrockPotFood;
import com.sihenzhang.crockpot.item.food.FlowerSalad;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCream;
import com.sihenzhang.crockpot.levelgen.CrockPotCropsFeature;
import com.sihenzhang.crockpot.levelgen.CrockPotCropsFeatureConfig;
import com.sihenzhang.crockpot.loot.CrockPotUnknownSeedsDropModifier;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class CrockPotRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crockpot");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"crockpot");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"crockpot");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"crockpot");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"crockpot");
    public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"crockpot");
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"crockpot");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"crockpot");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"crockpot");
    public static final MobEffect gnawsGift = CrockPotRegistry.register(MOB_EFFECTS, "gnaws_gift", new CrockPotEffect(MobEffectCategory.BENEFICIAL, 6621192));
    public static final MobEffect oceanAffinity = CrockPotRegistry.register(MOB_EFFECTS, "ocean_affinity", new CrockPotEffect(MobEffectCategory.BENEFICIAL, 1433076));
    public static final MobEffect wellFed = CrockPotRegistry.register(MOB_EFFECTS, "well_fed", new CrockPotEffect(MobEffectCategory.BENEFICIAL, 14317147).m_19472_(Attributes.f_22284_, "095FA141-E902-4BEF-99DB-DDC55213C07A", 1.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22281_, "5762F89C-8317-4021-B7EE-4DD93902941C", 1.0, AttributeModifier.Operation.ADDITION));
    public static final MobEffect witherResistanceEffect = CrockPotRegistry.register(MOB_EFFECTS, "wither_resistance", new CrockPotEffect(MobEffectCategory.BENEFICIAL, 7471247));
    public static final RecipeSerializer<CrockPotCookingRecipe> crockPotCooking = CrockPotRegistry.register(RECIPE_SERIALIZERS, "crock_pot_cooking", new CrockPotCookingRecipe.Serializer());
    public static final RecipeSerializer<ExplosionCraftingRecipe> explosionCrafting = CrockPotRegistry.register(RECIPE_SERIALIZERS, "explosion_crafting", new ExplosionCraftingRecipe.Serializer());
    public static final RecipeSerializer<FoodValuesDefinition> foodValues = CrockPotRegistry.register(RECIPE_SERIALIZERS, "food_values", new FoodValuesDefinition.Serializer());
    public static final RecipeSerializer<PiglinBarteringRecipe> piglinBartering = CrockPotRegistry.register(RECIPE_SERIALIZERS, "piglin_bartering", new PiglinBarteringRecipe.Serializer());
    public static final Block crockPotBasicBlock = (Block)CrockPotRegistry.register(BLOCKS, "crock_pot_basic", new AbstractCrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 0;
        }
    });
    public static final Item crockPotBasicBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_basic", new CrockPotBlockItem(crockPotBasicBlock));
    public static final Block crockPotAdvancedBlock = (Block)CrockPotRegistry.register(BLOCKS, "crock_pot_advanced", new AbstractCrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 1;
        }
    });
    public static final Item crockPotAdvancedBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_advanced", new CrockPotBlockItem(crockPotAdvancedBlock));
    public static final Block crockPotUltimateBlock = (Block)CrockPotRegistry.register(BLOCKS, "crock_pot_ultimate", new AbstractCrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 2;
        }
    });
    public static final Item crockPotUltimateBlockItem = (Item)CrockPotRegistry.register(ITEMS, "crock_pot_ultimate", new CrockPotBlockItem(crockPotUltimateBlock));
    public static final BlockEntityType<CrockPotBlockEntity> crockPotBlockEntity = CrockPotRegistry.register(BLOCK_ENTITIES, "crock_pot", BlockEntityType.Builder.m_155273_(CrockPotBlockEntity::new, (Block[])new Block[]{crockPotBasicBlock, crockPotAdvancedBlock, crockPotUltimateBlock}).m_58966_(null));
    public static final MenuType<CrockPotMenu> crockPotMenu = CrockPotRegistry.register(CONTAINERS, "crock_pot", IForgeMenuType.create((windowId, inv, data) -> new CrockPotMenu(windowId, inv, (CrockPotBlockEntity)inv.f_35978_.f_19853_.m_7702_(data.m_130135_()))));
    public static final GlobalLootModifierSerializer<CrockPotUnknownSeedsDropModifier> unknownSeedsDropModifier = CrockPotRegistry.register(LOOT_MODIFIER_SERIALIZERS, "unknown_seeds_drop", new CrockPotUnknownSeedsDropModifier.Serializer());
    public static final Block unknownCropsBlock = (Block)CrockPotRegistry.register(BLOCKS, "unknown_crops", new CrockPotUnknownCropsBlock());
    public static final Item unknownSeeds = (Item)CrockPotRegistry.register(ITEMS, "unknown_seeds", new CrockPotUnknownSeedsItem());
    public static final Feature<CrockPotCropsFeatureConfig> cropsPatchFeature = CrockPotRegistry.register(FEATURES, "crops_patch", new CrockPotCropsFeature(CrockPotCropsFeatureConfig.CODEC));
    public static final Block asparagusBlock = (Block)CrockPotRegistry.register(BLOCKS, "asparaguses", new AbstractCrockPotCropBlock(){

        @Override
        @Nonnull
        protected ItemLike m_6404_() {
            return asparagusSeeds;
        }
    });
    public static final Item asparagusSeeds = (Item)CrockPotRegistry.register(ITEMS, "asparagus_seeds", new CrockPotSeedsItem(asparagusBlock));
    public static final Item asparagus = CrockPotRegistry.register(ITEMS, "asparagus", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Block cornBlock = (Block)CrockPotRegistry.register(BLOCKS, "corns", new CornBlock());
    public static final Item cornSeeds = (Item)CrockPotRegistry.register(ITEMS, "corn_seeds", new CrockPotSeedsItem(cornBlock));
    public static final Item corn = CrockPotRegistry.register(ITEMS, "corn", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Item popcorn = CrockPotRegistry.register(ITEMS, "popcorn", CrockPotFood.builder().nutrition(3).saturationMod(0.8f).duration(FoodUseDuration.FAST).build());
    public static final Block eggplantBlock = (Block)CrockPotRegistry.register(BLOCKS, "eggplants", new AbstractCrockPotCropBlock(){

        @Override
        @Nonnull
        protected ItemLike m_6404_() {
            return eggplantSeeds;
        }
    });
    public static final Item eggplantSeeds = (Item)CrockPotRegistry.register(ITEMS, "eggplant_seeds", new CrockPotSeedsItem(eggplantBlock));
    public static final Item eggplant = CrockPotRegistry.register(ITEMS, "eggplant", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Item cookedEggplant = CrockPotRegistry.register(ITEMS, "cooked_eggplant", CrockPotFood.builder().nutrition(5).saturationMod(0.6f).build());
    public static final Block onionBlock = (Block)CrockPotRegistry.register(BLOCKS, "onions", new AbstractCrockPotCropBlock(){

        @Override
        @Nonnull
        protected ItemLike m_6404_() {
            return onionSeeds;
        }
    });
    public static final Item onionSeeds = (Item)CrockPotRegistry.register(ITEMS, "onion_seeds", new CrockPotSeedsItem(onionBlock));
    public static final Item onion = CrockPotRegistry.register(ITEMS, "onion", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Block pepperBlock = (Block)CrockPotRegistry.register(BLOCKS, "peppers", new AbstractCrockPotCropBlock(){

        @Override
        @Nonnull
        protected ItemLike m_6404_() {
            return pepperSeeds;
        }
    });
    public static final Item pepperSeeds = (Item)CrockPotRegistry.register(ITEMS, "pepper_seeds", new CrockPotSeedsItem(pepperBlock));
    public static final Item pepper = CrockPotRegistry.register(ITEMS, "pepper", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).damage(CrockPotDamageSource.SPICY, 1.0f).build());
    public static final Block tomatoBlock = (Block)CrockPotRegistry.register(BLOCKS, "tomatoes", new AbstractCrockPotCropBlock(){

        @Override
        @Nonnull
        protected ItemLike m_6404_() {
            return tomatoSeeds;
        }
    });
    public static final Item tomatoSeeds = (Item)CrockPotRegistry.register(ITEMS, "tomato_seeds", new CrockPotSeedsItem(tomatoBlock));
    public static final Item tomato = CrockPotRegistry.register(ITEMS, "tomato", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Set<Item> seeds = ImmutableSet.of((Object)unknownSeeds, (Object)asparagusSeeds, (Object)cornSeeds, (Object)eggplantSeeds, (Object)onionSeeds, (Object)pepperSeeds, (Object[])new Item[]{tomatoSeeds});
    public static final Set<Item> crops = ImmutableSet.of((Object)asparagus, (Object)corn, (Object)eggplant, (Object)onion, (Object)pepper, (Object)tomato, (Object[])new Item[0]);
    public static final Set<Item> cookedCrops = ImmutableSet.of((Object)popcorn, (Object)cookedEggplant);
    public static final Item blackstoneDust = CrockPotRegistry.register(ITEMS, "blackstone_dust", new Item(new Item.Properties().m_41491_(CrockPot.ITEM_GROUP)));
    public static final Item collectedDust = CrockPotRegistry.register(ITEMS, "collected_dust", new CollectedDustItem());
    public static final Item cookedEgg = CrockPotRegistry.register(ITEMS, "cooked_egg", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).build());
    public static final Item frogLegs = CrockPotRegistry.register(ITEMS, "frog_legs", CrockPotFood.builder().nutrition(2).saturationMod(0.4f).meat().build());
    public static final Item cookedFrogLegs = CrockPotRegistry.register(ITEMS, "cooked_frog_legs", CrockPotFood.builder().nutrition(5).saturationMod(0.7f).meat().build());
    public static final Item hoglinNose = CrockPotRegistry.register(ITEMS, "hoglin_nose", CrockPotFood.builder().nutrition(3).saturationMod(0.2f).meat().build());
    public static final Item cookedHoglinNose = CrockPotRegistry.register(ITEMS, "cooked_hoglin_nose", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).meat().build());
    public static final Item milkBottle = CrockPotRegistry.register(ITEMS, "milk_bottle", CrockPotFood.builder().nutrition(0).saturationMod(0.0f).alwaysEat().drink().tooltip("milk_bottle").build());
    public static final Item syrup = CrockPotRegistry.register(ITEMS, "syrup", CrockPotFood.builder().nutrition(1).saturationMod(0.3f).drink().build());
    public static final Item milkmadeHat = CrockPotRegistry.register(ITEMS, "milkmade_hat", new MilkmadeHatItem());
    public static final Item creativeMilkmadeHat = CrockPotRegistry.register(ITEMS, "creative_milkmade_hat", new CreativeMilkmadeHatItem());
    public static final Item gnawsCoin = CrockPotRegistry.register(ITEMS, "gnaws_coin", new GnawsCoinItem());
    public static final Item asparagusSoup = CrockPotRegistry.register(ITEMS, "asparagus_soup", CrockPotFood.builder().nutrition(4).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().removeEffect(MobEffects.f_19613_).removeEffect(MobEffects.f_19599_).removeEffect(MobEffects.f_19610_).removeEffect(MobEffects.f_19594_).build());
    public static final Item avaj = CrockPotRegistry.register(ITEMS, "avaj", CrockPotFood.builder().nutrition(2).saturationMod(3.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 38800, 2).hide().rarity(Rarity.EPIC).build());
    public static final Item baconEggs = CrockPotRegistry.register(ITEMS, "bacon_eggs", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).heal(4.0f).build());
    public static final Item boneSoup = CrockPotRegistry.register(ITEMS, "bone_soup", CrockPotFood.builder().nutrition(10).saturationMod(0.6f).effect(MobEffects.f_19617_, 2400, 1).build());
    public static final Item boneStew = CrockPotRegistry.register(ITEMS, "bone_stew", CrockPotFood.builder().nutrition(20).saturationMod(0.4f).duration(FoodUseDuration.SUPER_SLOW).effect(MobEffects.f_19601_, 1, 1).build());
    public static final Item bunnyStew = CrockPotRegistry.register(ITEMS, "bunny_stew", CrockPotFood.builder().nutrition(6).saturationMod(0.8f).effect(MobEffects.f_19605_, 100).effect(wellFed, 3600).build());
    public static final Item californiaRoll = CrockPotRegistry.register(ITEMS, "california_roll", CrockPotFood.builder().nutrition(10).saturationMod(0.6f).heal(4.0f).effect(MobEffects.f_19617_, 1200).build());
    public static final Item candy = CrockPotRegistry.register(ITEMS, "candy", new Candy());
    public static final Item ceviche = CrockPotRegistry.register(ITEMS, "ceviche", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).alwaysEat().effect(MobEffects.f_19606_, 400, 1).effect(MobEffects.f_19617_, 400, 1).build());
    public static final Item fishSticks = CrockPotRegistry.register(ITEMS, "fish_sticks", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).effect(MobEffects.f_19605_, 600).build());
    public static final Item fishTacos = CrockPotRegistry.register(ITEMS, "fish_tacos", CrockPotFood.builder().nutrition(8).saturationMod(0.9f).heal(2.0f).build());
    public static final Item flowerSalad = CrockPotRegistry.register(ITEMS, "flower_salad", new FlowerSalad());
    public static final Item froggleBunwich = CrockPotRegistry.register(ITEMS, "froggle_bunwich", CrockPotFood.builder().nutrition(7).saturationMod(0.8f).build());
    public static final Item fruitMedley = CrockPotRegistry.register(ITEMS, "fruit_medley", CrockPotFood.builder().nutrition(8).saturationMod(0.4f).effect(MobEffects.f_19596_, 3600).build());
    public static final Item gazpacho = CrockPotRegistry.register(ITEMS, "gazpacho", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19607_, 12000).build());
    public static final Item honeyHam = CrockPotRegistry.register(ITEMS, "honey_ham", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).effect(MobEffects.f_19605_, 400).effect(MobEffects.f_19617_, 1200, 1).heal(6.0f).build());
    public static final Item honeyNuggets = CrockPotRegistry.register(ITEMS, "honey_nuggets", CrockPotFood.builder().nutrition(8).saturationMod(0.3f).effect(MobEffects.f_19605_, 200).effect(MobEffects.f_19617_, 1200).heal(4.0f).build());
    public static final Item hotChili = CrockPotRegistry.register(ITEMS, "hot_chili", CrockPotFood.builder().nutrition(9).saturationMod(0.8f).effect(MobEffects.f_19600_, 1800).effect(MobEffects.f_19598_, 1800).build());
    public static final Item hotCocoa = CrockPotRegistry.register(ITEMS, "hot_cocoa", CrockPotFood.builder().nutrition(2).saturationMod(0.1f).alwaysEat().drink().effect(MobEffects.f_19596_, 9600, 1).removeEffect(MobEffects.f_19597_).removeEffect(MobEffects.f_19599_).build());
    public static final Item iceCream = CrockPotRegistry.register(ITEMS, "ice_cream", new IceCream());
    public static final Item icedTea = CrockPotRegistry.register(ITEMS, "iced_tea", CrockPotFood.builder().nutrition(3).saturationMod(0.1f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19603_, 6000, 1).build());
    public static final Item jammyPreserves = CrockPotRegistry.register(ITEMS, "jammy_preserves", CrockPotFood.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).build());
    public static final Item kabobs = CrockPotRegistry.register(ITEMS, "kabobs", CrockPotFood.builder().nutrition(7).saturationMod(0.7f).build());
    public static final Item meatBalls = CrockPotRegistry.register(ITEMS, "meat_balls", CrockPotFood.builder().nutrition(9).saturationMod(0.5f).build());
    public static final Item monsterLasagna = CrockPotRegistry.register(ITEMS, "monster_lasagna", CrockPotFood.builder().nutrition(7).saturationMod(0.2f).effect(MobEffects.f_19612_, 300).effect(MobEffects.f_19614_, 40).damage(CrockPotDamageSource.MONSTER_FOOD, 6.0f).build());
    public static final Item monsterTartare = CrockPotRegistry.register(ITEMS, "monster_tartare", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).effect(MobEffects.f_19600_, 2400, 1).build());
    public static final Item moqueca = CrockPotRegistry.register(ITEMS, "moqueca", CrockPotFood.builder().nutrition(14).saturationMod(0.7f).duration(FoodUseDuration.SLOW).effect(MobEffects.f_19616_, 1800, 2).heal(6.0f).build());
    public static final Item mushyCake = CrockPotRegistry.register(ITEMS, "mushy_cake", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(witherResistanceEffect, 1200).build());
    public static final Item netherosia = CrockPotRegistry.register(ITEMS, "netherosia", new NetherosiaItem());
    public static final Item pepperPopper = CrockPotRegistry.register(ITEMS, "pepper_popper", CrockPotFood.builder().nutrition(8).saturationMod(0.8f).effect(MobEffects.f_19600_, 1200, 1).build());
    public static final Item perogies = CrockPotRegistry.register(ITEMS, "perogies", CrockPotFood.builder().nutrition(8).saturationMod(0.8f).heal(6.0f).build());
    public static final Item potatoSouffle = CrockPotRegistry.register(ITEMS, "potato_souffle", CrockPotFood.builder().nutrition(8).saturationMod(0.7f).effect(MobEffects.f_19606_, 1800, 1).build());
    public static final Item potatoTornado = CrockPotRegistry.register(ITEMS, "potato_tornado", CrockPotFood.builder().nutrition(8).saturationMod(0.6f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build());
    public static final Item powCake = CrockPotRegistry.register(ITEMS, "pow_cake", CrockPotFood.builder().nutrition(2).saturationMod(0.1f).alwaysEat().damage(CrockPotDamageSource.POW_CAKE, 1.0f).build());
    public static final Item pumpkinCookie = CrockPotRegistry.register(ITEMS, "pumpkin_cookie", CrockPotFood.builder().nutrition(10).saturationMod(0.7f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build());
    public static final Item ratatouille = CrockPotRegistry.register(ITEMS, "ratatouille", CrockPotFood.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).build());
    public static final Item salmonSushi = CrockPotRegistry.register(ITEMS, "salmon_sushi", CrockPotFood.builder().nutrition(5).saturationMod(0.8f).duration(FoodUseDuration.FAST).heal(1.0f).build());
    public static final Item salsa = CrockPotRegistry.register(ITEMS, "salsa", CrockPotFood.builder().nutrition(7).saturationMod(0.8f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19598_, 7200).build());
    public static final Item seafoodGumbo = CrockPotRegistry.register(ITEMS, "seafood_gumbo", CrockPotFood.builder().nutrition(9).saturationMod(0.7f).effect(MobEffects.f_19605_, 2400).build());
    public static final Item stuffedEggplant = CrockPotRegistry.register(ITEMS, "stuffed_eggplant", CrockPotFood.builder().nutrition(7).saturationMod(0.6f).duration(FoodUseDuration.FAST).heal(2.0f).build());
    public static final Item surfNTurf = CrockPotRegistry.register(ITEMS, "surf_n_turf", CrockPotFood.builder().nutrition(8).saturationMod(1.2f).alwaysEat().effect(MobEffects.f_19605_, 600, 1).heal(8.0f).build());
    public static final Item taffy = CrockPotRegistry.register(ITEMS, "taffy", CrockPotFood.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(MobEffects.f_19621_, 9600).damage(CrockPotDamageSource.TAFFY, 1.0f).removeEffect(MobEffects.f_19614_).build());
    public static final Item tea = CrockPotRegistry.register(ITEMS, "tea", CrockPotFood.builder().nutrition(3).saturationMod(0.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19598_, 6000, 1).build());
    public static final Item tropicalBouillabaisse = CrockPotRegistry.register(ITEMS, "tropical_bouillabaisse", CrockPotFood.builder().nutrition(7).saturationMod(0.6f).alwaysEat().effect(oceanAffinity, 3000).build());
    public static final Item turkeyDinner = CrockPotRegistry.register(ITEMS, "turkey_dinner", CrockPotFood.builder().nutrition(12).saturationMod(0.8f).effect(MobEffects.f_19616_, 3600).build());
    public static final Item vegStinger = CrockPotRegistry.register(ITEMS, "veg_stinger", CrockPotFood.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19611_, 12000).build());
    public static final Item watermelonIcle = CrockPotRegistry.register(ITEMS, "watermelon_icle", CrockPotFood.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19596_, 3600).effect(MobEffects.f_19603_, 3600).removeEffect(MobEffects.f_19597_).build());
    public static final Item wetGoop = CrockPotRegistry.register(ITEMS, "wet_goop", CrockPotFood.builder().nutrition(0).saturationMod(0.0f).duration(FoodUseDuration.SUPER_SLOW).alwaysEat().effect(MobEffects.f_19604_, 200).tooltip("wet_goop", ChatFormatting.ITALIC, ChatFormatting.GRAY).build());
    public static final Map<FoodCategory, Item> foodCategoryItems = (Map)Util.m_137469_(new EnumMap(FoodCategory.class), map -> {
        for (FoodCategory category : FoodCategory.values()) {
            map.put(category, CrockPotRegistry.register(ITEMS, "food_category_" + category.name().toLowerCase(), new Item(new Item.Properties().m_41491_(CrockPot.ITEM_GROUP))));
        }
    });

    private static <T extends IForgeRegistryEntry<T>, E extends T> E register(DeferredRegister<T> register, String name, E entry) {
        register.register(name, () -> entry);
        return entry;
    }
}

