/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block.entity;

import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.AbstractCrockPotBlock;
import com.sihenzhang.crockpot.inventory.CrockPotMenu;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CrockPotBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot < 4 ? !CrockPotBlockEntity.this.isValidIngredient(stack) : slot == 4 && !CrockPotBlockEntity.isFuel(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CrockPotBlockEntity.this.hasChanged = true;
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 4);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 5);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 5, 6);
    private int burningTime;
    private int burningTotalTime;
    private int cookingTime;
    private int cookingTotalTime;
    private ItemStack result = ItemStack.f_41583_;
    private boolean hasChanged;
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerInputCap = LazyOptional.of(() -> this.itemHandlerInput);
    private final LazyOptional<IItemHandler> itemHandlerFuelCap = LazyOptional.of(() -> this.itemHandlerFuel);
    private final LazyOptional<IItemHandler> itemHandlerOutputCap = LazyOptional.of(() -> this.itemHandlerOutput);

    public CrockPotBlockEntity(BlockPos pos, BlockState state) {
        super(CrockPotRegistry.crockPotBlockEntity, pos, state);
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.crockpot.crock_pot");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new CrockPotMenu(containerId, inventory, this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrockPotBlockEntity blockEntity) {
        CrockPotCookingRecipe recipe;
        CrockPotCookingRecipeInput recipeInput;
        boolean isBurning = blockEntity.isBurning();
        if (blockEntity.isBurning()) {
            --blockEntity.burningTime;
            blockEntity.hasChanged = true;
        }
        if ((blockEntity.isBurning() || blockEntity.canConsumeFuel()) && !blockEntity.isCooking() && blockEntity.itemHandlerOutput.getStackInSlot(0).m_41619_() && (recipeInput = blockEntity.getRecipeInput()) != null && (recipe = CrockPotCookingRecipe.getRecipeFor(recipeInput, level.f_46441_, level.m_7465_())) != null) {
            blockEntity.cookingTotalTime = blockEntity.getActualCookingTotalTime(recipe);
            blockEntity.result = recipe.assemble();
            blockEntity.shrinkInputs();
            blockEntity.hasChanged = true;
        }
        if (blockEntity.canConsumeFuel() && blockEntity.isCooking()) {
            ItemStack fuelStack = blockEntity.itemHandlerFuel.getStackInSlot(0);
            ItemStack tmpFuelStack = fuelStack.m_41777_();
            tmpFuelStack.m_41764_(1);
            blockEntity.burningTime = blockEntity.burningTotalTime = ForgeHooks.getBurnTime((ItemStack)tmpFuelStack, null);
            fuelStack.m_41774_(1);
            if (fuelStack.m_41619_()) {
                blockEntity.itemHandlerFuel.setStackInSlot(0, tmpFuelStack.getContainerItem());
            }
            blockEntity.hasChanged = true;
        }
        if (blockEntity.isBurning() && blockEntity.isCooking() && blockEntity.itemHandlerOutput.getStackInSlot(0).m_41619_()) {
            ++blockEntity.cookingTime;
            if (blockEntity.cookingTime == blockEntity.cookingTotalTime) {
                blockEntity.cookingTime = 0;
                blockEntity.itemHandlerOutput.setStackInSlot(0, blockEntity.result);
                blockEntity.result = ItemStack.f_41583_;
            }
            blockEntity.hasChanged = true;
        }
        if (isBurning != blockEntity.isBurning()) {
            state = (BlockState)state.m_61124_((Property)AbstractCrockPotBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isBurning()));
            level.m_7731_(pos, state, 3);
            blockEntity.hasChanged = true;
        }
        if (blockEntity.hasChanged) {
            blockEntity.markUpdated(level, pos, state);
            blockEntity.hasChanged = false;
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getPotLevel() {
        return ((AbstractCrockPotBlock)this.m_58900_().m_60734_()).getPotLevel();
    }

    @Nullable
    public CrockPotCookingRecipeInput getRecipeInput() {
        int size = this.itemHandlerInput.getSlots();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stackInSlot = this.itemHandlerInput.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                return null;
            }
            ItemStack stack2 = stackInSlot.m_41777_();
            stack2.m_41764_(1);
            stacks.add(stack2);
        }
        FoodValues mergedFoodValues = FoodValues.merge(stacks.stream().map(stack -> FoodValuesDefinition.getFoodValues(stack.m_41720_(), this.f_58857_.m_7465_())).collect(Collectors.toList()));
        return new CrockPotCookingRecipeInput(mergedFoodValues, stacks, this.getPotLevel());
    }

    public boolean isValidIngredient(ItemStack stack) {
        return !FoodValuesDefinition.getFoodValues(stack.m_41720_(), this.f_58857_.m_7465_()).isEmpty();
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public boolean isBurning() {
        return this.burningTime > 0;
    }

    public float getBurningProgress() {
        return this.burningTotalTime != 0 ? (float)this.burningTime / (float)this.burningTotalTime : 0.0f;
    }

    public boolean isCooking() {
        return this.result != null && !this.result.m_41619_();
    }

    public float getCookingProgress() {
        return this.cookingTotalTime != 0 ? (float)this.cookingTime / (float)this.cookingTotalTime : 0.0f;
    }

    public ItemStack getResult() {
        return this.result;
    }

    private boolean canConsumeFuel() {
        ItemStack fuelStack;
        if (!this.isBurning() && !(fuelStack = this.itemHandlerFuel.getStackInSlot(0)).m_41619_()) {
            ItemStack tmpFuelStack = fuelStack.m_41777_();
            tmpFuelStack.m_41764_(1);
            return ForgeHooks.getBurnTime((ItemStack)tmpFuelStack, null) > 0;
        }
        return false;
    }

    private void shrinkInputs() {
        for (int i = 0; i < this.itemHandlerInput.getSlots(); ++i) {
            this.itemHandlerInput.getStackInSlot(i).m_41774_(1);
        }
    }

    private int getActualCookingTotalTime(CrockPotCookingRecipe recipe) {
        return Math.max((int)((double)recipe.getCookingTime() * (1.0 - (Double)CrockPotConfig.CROCK_POT_SPEED_MODIFIER.get() * (double)this.getPotLevel())), 1);
    }

    private void sendTileEntityUpdatePacket() {
        Packet<ClientGamePacketListener> pkt;
        if (!this.f_58857_.f_46443_ && (pkt = this.m_183216_()) != null) {
            ((ServerLevel)this.f_58857_).m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(p -> p.f_8906_.m_141995_(pkt));
        }
    }

    private void markUpdated(Level level, BlockPos pos, BlockState state) {
        CrockPotBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        this.sendTileEntityUpdatePacket();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("ItemHandler"));
        this.burningTime = tag.m_128451_("BurningTime");
        this.burningTotalTime = tag.m_128451_("BurningTotalTime");
        this.cookingTime = tag.m_128451_("CookingTime");
        this.cookingTotalTime = tag.m_128451_("CookingTotalTime");
        this.result.deserializeNBT(tag.m_128469_("Result"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("BurningTime", this.burningTime);
        tag.m_128405_("BurningTotalTime", this.burningTotalTime);
        tag.m_128405_("CookingTime", this.cookingTime);
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        tag.m_128365_("Result", (Tag)this.result.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemHandlerCap.cast();
            }
            return switch (side) {
                case Direction.UP -> this.itemHandlerInputCap.cast();
                case Direction.DOWN -> this.itemHandlerOutputCap.cast();
                default -> this.itemHandlerFuelCap.cast();
            };
        }
        return super.getCapability(cap, side);
    }
}

